/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeItemWriteListener
implements ItemWriteListener {
    private OrderedComposite listeners = new OrderedComposite();

    public void setListeners(ItemWriteListener[] itemWriteListeners) {
        this.listeners.setItems(itemWriteListeners);
    }

    public void register(ItemWriteListener itemReaderListener) {
        this.listeners.add(itemReaderListener);
    }

    public void afterWrite(Object item) {
        Iterator iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemWriteListener listener = (ItemWriteListener)iterator.next();
            listener.afterWrite(item);
        }
    }

    public void beforeWrite(Object item) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemWriteListener listener = (ItemWriteListener)iterator.next();
            listener.beforeWrite(item);
        }
    }

    public void onWriteError(Exception ex, Object item) {
        Iterator iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemWriteListener listener = (ItemWriteListener)iterator.next();
            listener.onWriteError(ex, item);
        }
    }
}

