/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JdbcExecutionContextDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;

public class JdbcStepExecutionDao
extends AbstractJdbcBatchMetadataDao
implements StepExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)JdbcStepExecutionDao.class);
    private static final String SAVE_STEP_EXECUTION = "INSERT into %PREFIX%STEP_EXECUTION(STEP_EXECUTION_ID, VERSION, STEP_NAME, JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, COMMIT_COUNT, ITEM_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, READ_SKIP_COUNT, WRITE_SKIP_COUNT, ROLLBACK_COUNT) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_STEP_EXECUTION = "UPDATE %PREFIX%STEP_EXECUTION set START_TIME = ?, END_TIME = ?, STATUS = ?, COMMIT_COUNT = ?, ITEM_COUNT = ?, CONTINUABLE = ? , EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ?, READ_SKIP_COUNT = ?, WRITE_SKIP_COUNT = ?, ROLLBACK_COUNT = ? where STEP_EXECUTION_ID = ? and VERSION = ?";
    private static final String GET_STEP_EXECUTION = "SELECT STEP_EXECUTION_ID, STEP_NAME, START_TIME, END_TIME, STATUS, COMMIT_COUNT, ITEM_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, READ_SKIP_COUNT, WRITE_SKIP_COUNT, ROLLBACK_COUNT from %PREFIX%STEP_EXECUTION where STEP_NAME = ? and JOB_EXECUTION_ID = ?";
    private static final String CURRENT_VERSION_STEP_EXECUTION = "SELECT VERSION FROM %PREFIX%STEP_EXECUTION WHERE STEP_EXECUTION_ID=?";
    private static final int DEFAULT_EXIT_MESSAGE_LENGTH = 2500;
    private int exitMessageLength = 2500;
    private LobHandler lobHandler = new DefaultLobHandler();
    private DataFieldMaxValueIncrementer stepExecutionIncrementer;
    private JdbcExecutionContextDao ecDao = new JdbcExecutionContextDao();

    public void setExitMessageLength(int exitMessageLength) {
        this.exitMessageLength = exitMessageLength;
    }

    public ExecutionContext findExecutionContext(StepExecution stepExecution) {
        return this.ecDao.getExecutionContext(stepExecution);
    }

    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isNull((Object)stepExecution.getId(), (String)"to-be-saved (not updated) StepExecution can't already have an id assigned");
        Assert.isNull((Object)stepExecution.getVersion(), (String)"to-be-saved (not updated) StepExecution can't already have a version assigned");
        this.validateStepExecution(stepExecution);
        String exitDescription = this.truncateExitDescription(stepExecution.getExitStatus().getExitDescription());
        stepExecution.setId(new Long(this.stepExecutionIncrementer.nextLongValue()));
        stepExecution.incrementVersion();
        Object[] parameters = new Object[]{stepExecution.getId(), stepExecution.getVersion(), stepExecution.getStepName(), stepExecution.getJobExecutionId(), stepExecution.getStartTime(), stepExecution.getEndTime(), stepExecution.getStatus().toString(), stepExecution.getCommitCount(), stepExecution.getItemCount(), stepExecution.getExitStatus().isContinuable() ? "Y" : "N", stepExecution.getExitStatus().getExitCode(), exitDescription, stepExecution.getReadSkipCount(), stepExecution.getWriteSkipCount(), stepExecution.getRollbackCount()};
        this.getJdbcTemplate().update(this.getQuery(SAVE_STEP_EXECUTION), parameters, new int[]{4, 4, 12, 4, 93, 93, 12, 4, 4, 1, 12, 12, 4, 4, 4});
    }

    private void validateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution);
        Assert.notNull((Object)stepExecution.getStepName(), (String)"StepExecution step name cannot be null.");
        Assert.notNull((Object)stepExecution.getStartTime(), (String)"StepExecution start time cannot be null.");
        Assert.notNull((Object)stepExecution.getStatus(), (String)"StepExecution status cannot be null.");
    }

    public void saveOrUpdateExecutionContext(StepExecution stepExecution) {
        this.ecDao.saveOrUpdateExecutionContext(stepExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStepExecution(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull((Object)stepExecution.getId(), (String)"StepExecution Id cannot be null. StepExecution must saved before it can be updated.");
        String exitDescription = this.truncateExitDescription(stepExecution.getExitStatus().getExitDescription());
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            Integer version = new Integer(stepExecution.getVersion() + 1);
            Object[] parameters = new Object[]{stepExecution.getStartTime(), stepExecution.getEndTime(), stepExecution.getStatus().toString(), stepExecution.getCommitCount(), stepExecution.getItemCount(), stepExecution.getExitStatus().isContinuable() ? "Y" : "N", stepExecution.getExitStatus().getExitCode(), exitDescription, version, stepExecution.getReadSkipCount(), stepExecution.getWriteSkipCount(), stepExecution.getRollbackCount(), stepExecution.getId(), stepExecution.getVersion()};
            int count = this.getJdbcTemplate().update(this.getQuery(UPDATE_STEP_EXECUTION), parameters, new int[]{93, 93, 12, 4, 4, 1, 12, 12, 4, 4, 4, 4, 4, 4});
            if (count == 0) {
                int curentVersion = this.getJdbcTemplate().queryForInt(this.getQuery(CURRENT_VERSION_STEP_EXECUTION), new Object[]{stepExecution.getId()});
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + curentVersion);
            }
            stepExecution.incrementVersion();
        }
    }

    private String truncateExitDescription(String description) {
        if (description != null && description.length() > this.exitMessageLength) {
            logger.debug((Object)("Truncating long message before update of StepExecution, original message is: " + description));
            return description.substring(0, this.exitMessageLength);
        }
        return description;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setStepExecutionIncrementer(DataFieldMaxValueIncrementer stepExecutionIncrementer) {
        this.stepExecutionIncrementer = stepExecutionIncrementer;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.stepExecutionIncrementer, (String)"StepExecutionIncrementer cannot be null.");
        this.ecDao.setJdbcTemplate(this.getJdbcTemplate());
        this.ecDao.setLobHandler(this.lobHandler);
        this.ecDao.setTablePrefix(this.getTablePrefix());
        this.ecDao.afterPropertiesSet();
    }

    public StepExecution getStepExecution(JobExecution jobExecution, Step step) {
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_STEP_EXECUTION), new Object[]{step.getName(), jobExecution.getId()}, (RowMapper)new StepExecutionRowMapper(jobExecution, step));
        Assert.state((executions.size() <= 1 ? 1 : 0) != 0, (String)"There can be at most one step execution with given name for single job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return (StepExecution)executions.get(0);
    }

    private class StepExecutionRowMapper
    implements RowMapper {
        private final JobExecution jobExecution;
        private final Step step;

        public StepExecutionRowMapper(JobExecution jobExecution, Step step) {
            this.jobExecution = jobExecution;
            this.step = step;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            StepExecution stepExecution = new StepExecution(this.step.getName(), this.jobExecution, new Long(rs.getLong(1)));
            stepExecution.setStartTime(rs.getTimestamp(3));
            stepExecution.setEndTime(rs.getTimestamp(4));
            stepExecution.setStatus(BatchStatus.getStatus(rs.getString(5)));
            stepExecution.setCommitCount(rs.getInt(6));
            stepExecution.setItemCount(rs.getInt(7));
            stepExecution.setExitStatus(new ExitStatus("Y".equals(rs.getString(8)), rs.getString(9), rs.getString(10)));
            stepExecution.setExecutionContext(JdbcStepExecutionDao.this.findExecutionContext(stepExecution));
            stepExecution.setReadSkipCount(rs.getInt(11));
            stepExecution.setWriteSkipCount(rs.getInt(12));
            stepExecution.setRollbackCount(rs.getInt(13));
            return stepExecution;
        }
    }
}

