/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import javax.sql.DataSource;
import org.springframework.batch.core.repository.dao.JdbcJobExecutionDao;
import org.springframework.batch.core.repository.dao.JdbcJobInstanceDao;
import org.springframework.batch.core.repository.dao.JdbcStepExecutionDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.AbstractJobRepositoryFactoryBean;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JobRepositoryFactoryBean
extends AbstractJobRepositoryFactoryBean {
    private DataSource dataSource;
    private JdbcOperations jdbcTemplate;
    private String databaseType;
    private String tablePrefix = "BATCH_";
    private DataFieldMaxValueIncrementerFactory incrementerFactory;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseType(String dbType) {
        this.databaseType = dbType;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setIncrementerFactory(DataFieldMaxValueIncrementerFactory incrementerFactory) {
        this.incrementerFactory = incrementerFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"DataSource must not be null.");
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        if (this.incrementerFactory == null) {
            this.incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(this.dataSource);
        }
        Assert.isTrue((boolean)this.incrementerFactory.isSupportedIncrementerType(this.databaseType), (String)("'" + this.databaseType + "' is an unsupported database type.  The supported database types are " + StringUtils.arrayToCommaDelimitedString((Object[])this.incrementerFactory.getSupportedIncrementerTypes())));
        super.afterPropertiesSet();
    }

    protected JobInstanceDao createJobInstanceDao() throws Exception {
        JdbcJobInstanceDao dao = new JdbcJobInstanceDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setJobIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }

    protected JobExecutionDao createJobExecutionDao() throws Exception {
        JdbcJobExecutionDao dao = new JdbcJobExecutionDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setJobExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "JOB_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }

    protected StepExecutionDao createStepExecutionDao() throws Exception {
        JdbcStepExecutionDao dao = new JdbcStepExecutionDao();
        dao.setJdbcTemplate(this.jdbcTemplate);
        dao.setStepExecutionIncrementer(this.incrementerFactory.getIncrementer(this.databaseType, this.tablePrefix + "STEP_EXECUTION_SEQ"));
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }
}

