/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.NoSuchJobException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractStep
implements Step,
InitializingBean,
BeanNameAware {
    public static final String JOB_INTERRUPTED = "JOB_INTERRUPTED";
    private static final Log logger = LogFactory.getLog((Class)AbstractStep.class);
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete = false;
    private CompositeStepExecutionListener listener = new CompositeStepExecutionListener();
    private JobRepository jobRepository;

    public AbstractStep() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository is mandatory");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public int getStartLimit() {
        return this.startLimit;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public boolean isAllowStartIfComplete() {
        return this.allowStartIfComplete;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public AbstractStep(String name) {
        this.name = name;
    }

    protected abstract ExitStatus doExecute(StepExecution var1) throws Exception;

    protected abstract void open(ExecutionContext var1) throws Exception;

    protected abstract void close(ExecutionContext var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute(StepExecution stepExecution) throws JobInterruptedException, UnexpectedJobExecutionException {
        block30: {
            Exception e4;
            Exception commitException;
            ExitStatus exitStatus;
            block25: {
                stepExecution.setStartTime(new Date());
                stepExecution.setStatus(BatchStatus.STARTED);
                this.getJobRepository().saveOrUpdate(stepExecution);
                exitStatus = ExitStatus.FAILED;
                commitException = null;
                this.getCompositeListener().beforeStep(stepExecution);
                try {
                    this.open(stepExecution.getExecutionContext());
                }
                catch (Exception e2) {
                    throw new UnexpectedJobExecutionException("Failed to initialize the step", e2);
                }
                exitStatus = this.doExecute(stepExecution);
                if (stepExecution.isTerminateOnly()) {
                    stepExecution.setStatus(BatchStatus.STOPPED);
                    throw new JobInterruptedException("JobExecution interrupted.");
                }
                stepExecution.setStatus(BatchStatus.COMPLETED);
                exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
                try {
                    this.getJobRepository().saveOrUpdate(stepExecution);
                    this.getJobRepository().saveOrUpdateExecutionContext(stepExecution);
                }
                catch (Exception e3) {
                    commitException = e3;
                    exitStatus = exitStatus.and(ExitStatus.UNKNOWN);
                }
                Object var7_7 = null;
                stepExecution.setExitStatus(exitStatus);
                stepExecution.setEndTime(new Date());
                try {
                    this.getJobRepository().saveOrUpdate(stepExecution);
                }
                catch (Exception e4) {
                    if (commitException == null) {
                        commitException = e4;
                        break block25;
                    }
                    logger.error((Object)"Exception while updating step execution after commit exception", (Throwable)e4);
                }
            }
            try {
                this.close(stepExecution.getExecutionContext());
            }
            catch (Exception e4) {
                logger.error((Object)"Exception while closing step execution resources", (Throwable)e4);
                throw new UnexpectedJobExecutionException("Exception while closing step resources", e4);
            }
            if (commitException != null) {
                stepExecution.setStatus(BatchStatus.UNKNOWN);
                logger.error((Object)"Encountered an error saving batch meta data.This job is now in an unknown state and should not be restarted.", (Throwable)commitException);
                throw new UnexpectedJobExecutionException("Encountered an error saving batch meta data.", commitException);
            }
            break block30;
            {
                catch (Throwable e5) {
                    block27: {
                        logger.error((Object)("Encountered an error executing the step: " + e5.getClass() + ": " + e5.getMessage()));
                        stepExecution.setStatus(AbstractStep.determineBatchStatus(e5));
                        exitStatus = this.getDefaultExitStatusForFailure(e5);
                        try {
                            exitStatus = exitStatus.and(this.getCompositeListener().onErrorInStep(stepExecution, e5));
                            this.getJobRepository().saveOrUpdateExecutionContext(stepExecution);
                        }
                        catch (Exception ex) {
                            logger.error((Object)"Encountered an error on listener error callback.", (Throwable)ex);
                        }
                        AbstractStep.rethrow(e5);
                        Object var7_8 = null;
                        stepExecution.setExitStatus(exitStatus);
                        stepExecution.setEndTime(new Date());
                        try {
                            this.getJobRepository().saveOrUpdate(stepExecution);
                        }
                        catch (Exception e4) {
                            if (commitException == null) {
                                commitException = e4;
                                break block27;
                            }
                            logger.error((Object)"Exception while updating step execution after commit exception", (Throwable)e4);
                        }
                    }
                    try {
                        this.close(stepExecution.getExecutionContext());
                    }
                    catch (Exception e4) {
                        logger.error((Object)"Exception while closing step execution resources", (Throwable)e4);
                        throw new UnexpectedJobExecutionException("Exception while closing step resources", e4);
                    }
                    if (commitException != null) {
                        stepExecution.setStatus(BatchStatus.UNKNOWN);
                        logger.error((Object)"Encountered an error saving batch meta data.This job is now in an unknown state and should not be restarted.", (Throwable)commitException);
                        throw new UnexpectedJobExecutionException("Encountered an error saving batch meta data.", commitException);
                    }
                }
            }
            catch (Throwable throwable) {
                block29: {
                    Object var7_9 = null;
                    stepExecution.setExitStatus(exitStatus);
                    stepExecution.setEndTime(new Date());
                    try {
                        this.getJobRepository().saveOrUpdate(stepExecution);
                    }
                    catch (Exception e4) {
                        if (commitException == null) {
                            commitException = e4;
                            break block29;
                        }
                        logger.error((Object)"Exception while updating step execution after commit exception", (Throwable)e4);
                    }
                }
                try {
                    this.close(stepExecution.getExecutionContext());
                }
                catch (Exception e4) {
                    logger.error((Object)"Exception while closing step execution resources", (Throwable)e4);
                    throw new UnexpectedJobExecutionException("Exception while closing step resources", e4);
                }
                if (commitException != null) {
                    stepExecution.setStatus(BatchStatus.UNKNOWN);
                    logger.error((Object)"Encountered an error saving batch meta data.This job is now in an unknown state and should not be restarted.", (Throwable)commitException);
                    throw new UnexpectedJobExecutionException("Encountered an error saving batch meta data.", commitException);
                }
                throw throwable;
            }
        }
    }

    private static void rethrow(Throwable e) throws JobInterruptedException {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof JobInterruptedException) {
            throw (JobInterruptedException)e;
        }
        if (e.getCause() instanceof JobInterruptedException) {
            throw (JobInterruptedException)e.getCause();
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new UnexpectedJobExecutionException("Unexpected checked exception in step execution", e);
    }

    private static BatchStatus determineBatchStatus(Throwable e) {
        if (e instanceof FatalException) {
            return BatchStatus.UNKNOWN;
        }
        if (e instanceof JobInterruptedException || e.getCause() instanceof JobInterruptedException) {
            return BatchStatus.STOPPED;
        }
        return BatchStatus.FAILED;
    }

    public void registerStepExecutionListener(StepExecutionListener listener) {
        this.listener.register(listener);
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    protected StepExecutionListener getCompositeListener() {
        return this.listener;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    protected JobRepository getJobRepository() {
        return this.jobRepository;
    }

    private ExitStatus getDefaultExitStatusForFailure(Throwable ex) {
        ExitStatus exitStatus;
        if (ex instanceof JobInterruptedException || ex.getCause() instanceof JobInterruptedException) {
            exitStatus = new ExitStatus(false, JOB_INTERRUPTED, JobInterruptedException.class.getName());
        } else if (ex instanceof NoSuchJobException || ex.getCause() instanceof NoSuchJobException) {
            exitStatus = new ExitStatus(false, "NO_SUCH_JOB");
        } else {
            String message = "";
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            message = writer.toString();
            exitStatus = ExitStatus.FAILED.addExitDescription(message);
        }
        return exitStatus;
    }

    protected static class FatalException
    extends RuntimeException {
        public FatalException(String string, Throwable e) {
            super(string, e);
        }
    }
}

