/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.core.step.item.SimpleItemHandler;
import org.springframework.batch.core.step.item.TransactionInterceptorValidator;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.validator.Validator;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public abstract class AbstractStepFactoryBean
implements FactoryBean,
BeanNameAware {
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete;
    private ItemReader itemReader;
    private ItemWriter itemWriter;
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute;
    private JobRepository jobRepository;
    private boolean singleton = true;
    private Validator jobRepositoryValidator = new TransactionInterceptorValidator(1);
    private ItemStream[] streams = new ItemStream[0];
    private StepListener[] listeners = new StepListener[0];

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setItemReader(ItemReader itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemWriter(ItemWriter itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    protected StepListener[] getListeners() {
        return this.listeners;
    }

    protected ItemReader getItemReader() {
        return this.itemReader;
    }

    protected ItemWriter getItemWriter() {
        return this.itemWriter;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    protected TransactionAttribute getTransactionAttribute() {
        return this.transactionAttribute != null ? this.transactionAttribute : new DefaultTransactionAttribute();
    }

    public final Object getObject() throws Exception {
        ItemOrientedStep step = new ItemOrientedStep(this.getName());
        this.applyConfiguration(step);
        return step;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        Assert.notNull((Object)this.getItemReader(), (String)"ItemReader must be provided");
        Assert.notNull((Object)this.getItemWriter(), (String)"ItemWriter must be provided");
        Assert.notNull((Object)this.transactionManager, (String)"TransactionManager must be provided");
        this.jobRepositoryValidator.validate((Object)this.jobRepository);
        step.setItemHandler(new SimpleItemHandler(this.itemReader, this.itemWriter));
        step.setTransactionManager(this.transactionManager);
        if (this.transactionAttribute != null) {
            step.setTransactionAttribute(this.transactionAttribute);
        }
        step.setJobRepository(this.jobRepository);
        step.setStartLimit(this.startLimit);
        step.setAllowStartIfComplete(this.allowStartIfComplete);
        step.setStreams(this.streams);
        ItemReader itemReader = this.getItemReader();
        ItemWriter itemWriter = this.getItemWriter();
        if (itemReader instanceof ItemStream) {
            step.registerStream((ItemStream)itemReader);
        }
        if (itemReader instanceof StepExecutionListener) {
            step.registerStepExecutionListener((StepExecutionListener)itemReader);
        }
        if (itemWriter instanceof ItemStream) {
            step.registerStream((ItemStream)itemWriter);
        }
        if (itemWriter instanceof StepExecutionListener) {
            step.registerStepExecutionListener((StepExecutionListener)itemWriter);
        }
        StepExecutionListener[] stepListeners = BatchListenerFactoryHelper.getStepListeners(this.listeners);
        itemReader = BatchListenerFactoryHelper.getItemReader(itemReader, this.listeners);
        itemWriter = BatchListenerFactoryHelper.getItemWriter(itemWriter, this.listeners);
        this.setItemReader(itemReader);
        this.setItemWriter(itemWriter);
        step.setStepExecutionListeners(stepListeners);
        step.setItemHandler(new SimpleItemHandler(itemReader, itemWriter));
    }

    public Class getObjectType() {
        return Step.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }
}

