/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.listener.RetryListenerSupport;
import org.springframework.batch.support.BinaryExceptionClassifier;

public class SimpleRetryExceptionHandler
extends RetryListenerSupport
implements ExceptionHandler {
    private static final String EXHAUSTED = SimpleRetryExceptionHandler.class.getName() + ".RETRY_EXHAUSTED";
    private final RetryPolicy retryPolicy;
    private final ExceptionHandler exceptionHandler;
    private final BinaryExceptionClassifier fatalExceptionClassifier;

    public SimpleRetryExceptionHandler(RetryPolicy retryPolicy, ExceptionHandler exceptionHandler, Class[] classes) {
        this.retryPolicy = retryPolicy;
        this.exceptionHandler = exceptionHandler;
        this.fatalExceptionClassifier = new BinaryExceptionClassifier();
        this.fatalExceptionClassifier.setExceptionClasses(classes);
    }

    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        if (!this.fatalExceptionClassifier.isDefault(throwable) || context.hasAttribute(EXHAUSTED)) {
            this.exceptionHandler.handleException(context, throwable);
        }
    }

    public void close(RetryContext context, RetryCallback callback, Throwable throwable) {
        if (!this.retryPolicy.canRetry(context)) {
            this.getRepeatContext().setAttribute(EXHAUSTED, (Object)"true");
        }
    }

    private RepeatContext getRepeatContext() {
        RepeatContext context = RepeatSynchronizationManager.getContext();
        if (context.getParent() != null) {
            return context.getParent();
        }
        return context;
    }
}

