/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.step.item.AbstractStepFactoryBean;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ItemHandler;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class SimpleStepFactoryBean
extends AbstractStepFactoryBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_COMMIT_INTERVAL = 1;
    private int commitInterval = 0;
    private TaskExecutor taskExecutor;
    private ItemHandler itemHandler;
    private RepeatTemplate stepOperations;
    private RepeatTemplate chunkOperations;
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private CompletionPolicy chunkCompletionPolicy;
    private int throttleLimit = 4;

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    protected RepeatTemplate getStepOperations() {
        return this.stepOperations;
    }

    protected RepeatTemplate getChunkOperations() {
        return this.chunkOperations;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setThrottleLimit(int throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    protected ItemHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void setItemHandler(ItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        super.applyConfiguration(step);
        this.chunkOperations = new RepeatTemplate();
        this.chunkOperations.setCompletionPolicy(this.getChunkCompletionPolicy());
        BatchListenerFactoryHelper.addChunkListeners((RepeatOperations)this.chunkOperations, this.getListeners());
        step.setChunkOperations((RepeatOperations)this.chunkOperations);
        this.stepOperations = new RepeatTemplate();
        if (this.taskExecutor != null) {
            TaskExecutorRepeatTemplate repeatTemplate = new TaskExecutorRepeatTemplate();
            repeatTemplate.setTaskExecutor(this.taskExecutor);
            repeatTemplate.setThrottleLimit(this.throttleLimit);
            this.stepOperations = repeatTemplate;
        }
        this.stepOperations.setExceptionHandler(this.exceptionHandler);
        step.setStepOperations((RepeatOperations)this.stepOperations);
    }

    private CompletionPolicy getChunkCompletionPolicy() {
        Assert.state((this.chunkCompletionPolicy == null || this.commitInterval == 0 ? 1 : 0) != 0, (String)"You must specify either a chunkCompletionPolicy or a commitInterval but not both.");
        Assert.state((this.commitInterval >= 0 ? 1 : 0) != 0, (String)"The commitInterval must be positive or zero (for default value).");
        if (this.chunkCompletionPolicy != null) {
            return this.chunkCompletionPolicy;
        }
        if (this.commitInterval == 0) {
            this.logger.info((Object)"Setting commit interval to default value (1)");
            this.commitInterval = 1;
        }
        return new SimpleCompletionPolicy(this.commitInterval);
    }
}

