/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import org.springframework.batch.core.StepExecution;

public class StepContribution {
    private volatile int itemCount = 0;
    private final int parentSkipCount;
    private volatile int commitCount;
    private volatile int readSkipCount;
    private volatile int writeSkipCount;
    private volatile int uncommitedReadSkipCount;

    public StepContribution(StepExecution execution) {
        this.parentSkipCount = execution.getSkipCount();
    }

    public void incrementItemCount() {
        ++this.itemCount;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void incrementCommitCount() {
        ++this.commitCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public int getStepSkipCount() {
        return this.uncommitedReadSkipCount + this.readSkipCount + this.writeSkipCount + this.parentSkipCount;
    }

    public int getSkipCount() {
        return this.readSkipCount + this.writeSkipCount;
    }

    public void incrementReadsSkipCount() {
        ++this.readSkipCount;
    }

    public void incrementWriteSkipCount() {
        ++this.writeSkipCount;
    }

    public void incrementTemporaryReadSkipCount() {
        ++this.uncommitedReadSkipCount;
    }

    public int getReadSkipCount() {
        return this.readSkipCount;
    }

    public int getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public void combineSkipCounts() {
        this.readSkipCount += this.uncommitedReadSkipCount;
        this.uncommitedReadSkipCount = 0;
    }

    public String toString() {
        return "[StepContribution: items=" + this.itemCount + ", commits=" + this.commitCount + ", uncommitedReadSkips=" + this.uncommitedReadSkipCount + ", readSkips=" + this.readSkipCount + "writeSkips=" + this.writeSkipCount + "]";
    }
}

