/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.util.Date;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.util.Assert;

public class StepExecution
extends Entity {
    private final JobExecution jobExecution;
    private final String stepName;
    private volatile BatchStatus status = BatchStatus.STARTING;
    private volatile int itemCount = 0;
    private volatile int commitCount = 0;
    private volatile int rollbackCount = 0;
    private volatile int readSkipCount = 0;
    private volatile int writeSkipCount = 0;
    private volatile Date startTime = new Date(System.currentTimeMillis());
    private volatile Date endTime = null;
    private volatile ExecutionContext executionContext = new ExecutionContext();
    private volatile ExitStatus exitStatus = ExitStatus.CONTINUABLE;
    private volatile boolean terminateOnly;

    public StepExecution(String stepName, JobExecution jobExecution, Long id) {
        super(id);
        Assert.hasLength((String)stepName);
        this.stepName = stepName;
        this.jobExecution = jobExecution;
    }

    public StepExecution(String stepName, JobExecution jobExecution) {
        this(stepName, jobExecution, null);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public Integer getCommitCount() {
        return new Integer(this.commitCount);
    }

    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getItemCount() {
        return new Integer(this.itemCount);
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public Integer getRollbackCount() {
        return new Integer(this.rollbackCount);
    }

    public void setRollbackCount(int rollbackCount) {
        this.rollbackCount = rollbackCount;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public String getStepName() {
        return this.stepName;
    }

    public Long getJobExecutionId() {
        if (this.jobExecution != null) {
            return this.jobExecution.getId();
        }
        return null;
    }

    public boolean equals(Object obj) {
        Long jobExecutionId = this.getJobExecutionId();
        if (jobExecutionId == null || !(obj instanceof StepExecution) || this.getId() == null) {
            return super.equals(obj);
        }
        StepExecution other = (StepExecution)obj;
        return this.stepName.equals(other.getStepName()) && ((Object)jobExecutionId).equals(other.getJobExecutionId());
    }

    public int hashCode() {
        Long jobExecutionId = this.getJobExecutionId();
        return super.hashCode() + 31 * (this.stepName != null ? this.stepName.hashCode() : 0) + 91 * (jobExecutionId != null ? ((Object)jobExecutionId).hashCode() : 0);
    }

    public String toString() {
        return super.toString() + ", name=" + this.stepName + ", itemCount=" + this.itemCount + ", commitCount=" + this.commitCount + ", rollbackCount=" + this.rollbackCount;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public StepContribution createStepContribution() {
        return new StepContribution(this);
    }

    public synchronized void apply(StepContribution contribution) {
        this.itemCount += contribution.getItemCount();
        this.commitCount += contribution.getCommitCount();
        contribution.combineSkipCounts();
        this.readSkipCount += contribution.getReadSkipCount();
        this.writeSkipCount += contribution.getWriteSkipCount();
    }

    public synchronized void rollback() {
        ++this.rollbackCount;
    }

    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    public void setTerminateOnly() {
        this.terminateOnly = true;
    }

    public int getSkipCount() {
        return this.readSkipCount + this.writeSkipCount;
    }

    public void incrementReadSkipCountBy(int count) {
        this.readSkipCount += count;
    }

    public void incrementWriteSkipCountBy(int count) {
        this.writeSkipCount += count;
    }

    public JobParameters getJobParameters() {
        if (this.jobExecution == null || this.jobExecution.getJobInstance() == null) {
            return new JobParameters();
        }
        return this.jobExecution.getJobInstance().getJobParameters();
    }

    public Integer getReadSkipCount() {
        return new Integer(this.readSkipCount);
    }

    public Integer getWriteSkipCount() {
        return new Integer(this.writeSkipCount);
    }

    public void setReadSkipCount(int readSkipCount) {
        this.readSkipCount = readSkipCount;
    }

    public void setWriteSkipCount(int writeSkipCount) {
        this.writeSkipCount = writeSkipCount;
    }
}

