/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ReferenceJobFactory;
import org.springframework.batch.core.repository.DuplicateJobException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.Assert;

public class JobRegistryBeanPostProcessor
implements BeanPostProcessor,
InitializingBean,
DisposableBean {
    private JobRegistry jobConfigurationRegistry = null;
    private Collection jobNames = new HashSet();

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobConfigurationRegistry = jobRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobConfigurationRegistry, (String)"JobConfigurationRegistry must not be null");
    }

    public void destroy() throws Exception {
        Iterator iter = this.jobNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.jobConfigurationRegistry.unregister(name);
        }
        this.jobNames.clear();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Job) {
            Job job = (Job)bean;
            try {
                this.jobConfigurationRegistry.register(new ReferenceJobFactory(job));
                this.jobNames.add(job.getName());
            }
            catch (DuplicateJobException e) {
                throw new FatalBeanException("Cannot register job configuration", (Throwable)e);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

