/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;

public class SimpleJob
extends AbstractJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(JobExecution execution) throws JobExecutionException {
        ExitStatus status2222;
        block25: {
            StepExecution currentStepExecution;
            block22: {
                block23: {
                    JobInstance jobInstance = execution.getJobInstance();
                    currentStepExecution = null;
                    int startedCount = 0;
                    List steps = this.getSteps();
                    try {
                        try {
                            if (execution.getStatus() == BatchStatus.STOPPING) {
                                throw new JobInterruptedException("JobExecution already stopped before being executed.");
                            }
                            execution.setStartTime(new Date());
                            this.updateStatus(execution, BatchStatus.STARTING);
                            this.getCompositeListener().beforeJob(execution);
                            Iterator i = steps.iterator();
                            while (i.hasNext()) {
                                boolean isRestart;
                                if (execution.getStatus() == BatchStatus.STOPPING) {
                                    throw new JobInterruptedException("JobExecution interrupted.");
                                }
                                Step step = (Step)i.next();
                                if (!this.shouldStart(jobInstance, step)) continue;
                                ++startedCount;
                                this.updateStatus(execution, BatchStatus.STARTED);
                                currentStepExecution = execution.createStepExecution(step);
                                StepExecution lastStepExecution = this.getJobRepository().getLastStepExecution(jobInstance, step);
                                boolean bl = isRestart = lastStepExecution != null && !lastStepExecution.getStatus().equals(BatchStatus.COMPLETED);
                                if (isRestart) {
                                    currentStepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
                                } else {
                                    currentStepExecution.setExecutionContext(new ExecutionContext());
                                }
                                step.execute(currentStepExecution);
                            }
                            if (execution.getStatus() == BatchStatus.STOPPING) {
                                throw new JobInterruptedException("JobExecution interrupted.");
                            }
                            this.updateStatus(execution, BatchStatus.COMPLETED);
                            this.getCompositeListener().afterJob(execution);
                        }
                        catch (JobInterruptedException e) {
                            execution.setStatus(BatchStatus.STOPPED);
                            this.getCompositeListener().onInterrupt(execution);
                            SimpleJob.rethrow(e);
                            Object var11_13 = null;
                            ExitStatus status2222 = ExitStatus.FAILED;
                            if (startedCount == 0) {
                                status2222 = steps.size() > 0 ? ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.") : ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                            } else if (currentStepExecution != null) {
                                status2222 = currentStepExecution.getExitStatus();
                            }
                            execution.setEndTime(new Date());
                            execution.setExitStatus(status2222);
                            this.getJobRepository().saveOrUpdate(execution);
                            return;
                        }
                        catch (Throwable t) {
                            execution.setStatus(BatchStatus.FAILED);
                            this.getCompositeListener().onError(execution, t);
                            SimpleJob.rethrow(t);
                            Object var11_14 = null;
                            ExitStatus status2222 = ExitStatus.FAILED;
                            if (startedCount == 0) {
                                status2222 = steps.size() > 0 ? ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.") : ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                            } else if (currentStepExecution != null) {
                                status2222 = currentStepExecution.getExitStatus();
                            }
                            execution.setEndTime(new Date());
                            execution.setExitStatus(status2222);
                            this.getJobRepository().saveOrUpdate(execution);
                            return;
                        }
                        Object var11_12 = null;
                        status2222 = ExitStatus.FAILED;
                        if (startedCount != 0) break block22;
                        if (steps.size() <= 0) break block23;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        ExitStatus status2222 = ExitStatus.FAILED;
                        if (startedCount == 0) {
                            status2222 = steps.size() > 0 ? ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.") : ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                        } else if (currentStepExecution != null) {
                            status2222 = currentStepExecution.getExitStatus();
                        }
                        execution.setEndTime(new Date());
                        execution.setExitStatus(status2222);
                        this.getJobRepository().saveOrUpdate(execution);
                        throw throwable;
                    }
                    status2222 = ExitStatus.NOOP.addExitDescription("All steps already completed.  No processing was done.");
                    break block25;
                }
                status2222 = ExitStatus.NOOP.addExitDescription("No steps configured for this job.");
                break block25;
            }
            if (currentStepExecution != null) {
                status2222 = currentStepExecution.getExitStatus();
            }
        }
        execution.setEndTime(new Date());
        execution.setExitStatus(status2222);
        this.getJobRepository().saveOrUpdate(execution);
    }

    private void updateStatus(JobExecution jobExecution, BatchStatus status) {
        jobExecution.setStatus(status);
        this.getJobRepository().saveOrUpdate(jobExecution);
    }

    private boolean shouldStart(JobInstance jobInstance, Step step) throws JobExecutionException {
        StepExecution lastStepExecution = this.getJobRepository().getLastStepExecution(jobInstance, step);
        BatchStatus stepStatus = lastStepExecution == null ? BatchStatus.STARTING : lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobExecutionException("Cannot restart step from UNKNOWN status.  The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete()) {
            return false;
        }
        if (this.getJobRepository().getStepExecutionCount(jobInstance, step) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }

    private static void rethrow(Throwable t) throws RuntimeException {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UnexpectedJobExecutionException("Unexpected checked exception in job execution", t);
    }
}

