/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeExecutionJobListener
implements JobExecutionListener {
    private OrderedComposite listeners = new OrderedComposite();

    public void setListeners(JobExecutionListener[] listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(JobExecutionListener jobExecutionListener) {
        this.listeners.add(jobExecutionListener);
    }

    public void afterJob(JobExecution jobExecution) {
        Iterator iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.afterJob(jobExecution);
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.beforeJob(jobExecution);
        }
    }

    public void onError(JobExecution jobExecution, Throwable e) {
        Iterator iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.onError(jobExecution, e);
        }
    }

    public void onInterrupt(JobExecution jobExecution) {
        Iterator iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            JobExecutionListener listener = (JobExecutionListener)iterator.next();
            listener.onInterrupt(jobExecution);
        }
    }
}

