/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeItemReadListener
implements ItemReadListener {
    private OrderedComposite listeners = new OrderedComposite();

    public void setListeners(ItemReadListener[] itemReadListeners) {
        this.listeners.setItems(itemReadListeners);
    }

    public void register(ItemReadListener itemReaderListener) {
        this.listeners.add(itemReaderListener);
    }

    public void afterRead(Object item) {
        Iterator iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemReadListener listener = (ItemReadListener)iterator.next();
            listener.afterRead(item);
        }
    }

    public void beforeRead() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemReadListener listener = (ItemReadListener)iterator.next();
            listener.beforeRead();
        }
    }

    public void onReadError(Exception ex) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemReadListener listener = (ItemReadListener)iterator.next();
            listener.onReadError(ex);
        }
    }
}

