/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.SimpleJobRepository;
import org.springframework.batch.support.PropertiesConverter;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public abstract class AbstractJobRepositoryFactoryBean
implements FactoryBean,
InitializingBean {
    private static final String DEFAULT_ISOLATION_LEVEL = "ISOLATION_SERIALIZABLE";
    private ProxyFactory proxyFactory;
    private String isolationLevelForCreate = "ISOLATION_SERIALIZABLE";
    private PlatformTransactionManager transactionManager;

    protected abstract JobInstanceDao createJobInstanceDao() throws Exception;

    protected abstract JobExecutionDao createJobExecutionDao() throws Exception;

    protected abstract StepExecutionDao createStepExecutionDao() throws Exception;

    public Object getObject() throws Exception {
        return this.proxyFactory.getProxy();
    }

    public Class getObjectType() {
        return JobRepository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.transactionManager, (String)"TransactionManager must not be null.");
        this.initializeProxy();
    }

    protected void initializeProxy() throws Exception {
        this.proxyFactory = new ProxyFactory();
        TransactionInterceptor advice = new TransactionInterceptor(this.transactionManager, PropertiesConverter.stringToProperties((String)("create*=PROPAGATION_REQUIRES_NEW," + this.isolationLevelForCreate + "\n*=PROPAGATION_REQUIRED")));
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor((Advice)advice);
        NameMatchMethodPointcut pointcut = new NameMatchMethodPointcut();
        pointcut.addMethodName("*");
        advisor.setPointcut((Pointcut)pointcut);
        this.proxyFactory.addAdvisor((Advisor)advisor);
        this.proxyFactory.setProxyTargetClass(false);
        this.proxyFactory.addInterface(JobRepository.class);
        this.proxyFactory.setTarget(this.getTarget());
    }

    private Object getTarget() throws Exception {
        return new SimpleJobRepository(this.createJobInstanceDao(), this.createJobExecutionDao(), this.createStepExecutionDao());
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setIsolationLevelForCreate(String isolationLevelForCreate) {
        this.isolationLevelForCreate = isolationLevelForCreate;
    }
}

