/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.StepExecutionSynchronizer;
import org.springframework.batch.core.step.StepExecutionSynchronizerFactory;
import org.springframework.batch.core.step.StepInterruptionPolicy;
import org.springframework.batch.core.step.ThreadStepInterruptionPolicy;
import org.springframework.batch.core.step.item.ItemHandler;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.CompositeItemStream;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class ItemOrientedStep
extends AbstractStep {
    private static final Log logger = LogFactory.getLog((Class)ItemOrientedStep.class);
    private RepeatOperations chunkOperations = new RepeatTemplate();
    private RepeatOperations stepOperations = new RepeatTemplate();
    private StepInterruptionPolicy interruptionPolicy = new ThreadStepInterruptionPolicy();
    private CompositeItemStream stream = new CompositeItemStream();
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute = new DefaultTransactionAttribute(){

        public boolean rollbackOn(Throwable ex) {
            return true;
        }
    };
    private ItemHandler itemHandler;
    private StepExecutionSynchronizer synchronizer = new StepExecutionSynchronizerFactory().getStepExecutionSynchronizer();

    public ItemOrientedStep(String name) {
        super(name);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setItemHandler(ItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    public void setStreams(ItemStream[] streams) {
        for (int i = 0; i < streams.length; ++i) {
            this.registerStream(streams[i]);
        }
    }

    public void registerStream(ItemStream stream) {
        this.stream.register(stream);
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setChunkOperations(RepeatOperations chunkOperations) {
        this.chunkOperations = chunkOperations;
    }

    public void setInterruptionPolicy(StepInterruptionPolicy interruptionPolicy) {
        this.interruptionPolicy = interruptionPolicy;
    }

    public void setSynchronizer(StepExecutionSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    protected ExitStatus doExecute(final StepExecution stepExecution) throws Exception {
        this.stream.update(stepExecution.getExecutionContext());
        this.getJobRepository().saveOrUpdateExecutionContext(stepExecution);
        this.itemHandler.mark();
        final ExceptionHolder fatalException = new ExceptionHolder();
        return this.stepOperations.iterate(new RepeatCallback(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public ExitStatus doInIteration(RepeatContext context) throws Exception {
                ExitStatus exitStatus;
                block19: {
                    StepContribution contribution = stepExecution.createStepContribution();
                    if (stepExecution.isTerminateOnly()) {
                        context.setTerminateOnly();
                    }
                    ItemOrientedStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                    exitStatus = ExitStatus.CONTINUABLE;
                    TransactionStatus transaction = ItemOrientedStep.this.transactionManager.getTransaction((TransactionDefinition)ItemOrientedStep.this.transactionAttribute);
                    boolean locked = false;
                    Object nonRollbackException = null;
                    try {
                        try {
                            exitStatus = ItemOrientedStep.this.processChunk(stepExecution, contribution);
                            contribution.incrementCommitCount();
                            try {
                                ItemOrientedStep.this.synchronizer.lock(stepExecution);
                                locked = true;
                            }
                            catch (InterruptedException e) {
                                stepExecution.setStatus(BatchStatus.STOPPED);
                                Thread.currentThread().interrupt();
                            }
                            stepExecution.apply(contribution);
                            ItemOrientedStep.this.itemHandler.flush();
                            ItemOrientedStep.this.stream.update(stepExecution.getExecutionContext());
                            try {
                                ItemOrientedStep.this.getJobRepository().saveOrUpdateExecutionContext(stepExecution);
                            }
                            catch (Exception e) {
                                fatalException.setException(e);
                                stepExecution.setStatus(BatchStatus.UNKNOWN);
                                throw new AbstractStep.FatalException("Fatal error detected during save of step execution context", e);
                            }
                            try {
                                ItemOrientedStep.this.itemHandler.mark();
                                ItemOrientedStep.this.transactionManager.commit(transaction);
                            }
                            catch (Exception e) {
                                fatalException.setException(e);
                                stepExecution.setStatus(BatchStatus.UNKNOWN);
                                logger.error((Object)"Fatal error detected during commit.");
                                throw new AbstractStep.FatalException("Fatal error detected during commit", e);
                            }
                            try {
                                ItemOrientedStep.this.getJobRepository().saveOrUpdate(stepExecution);
                            }
                            catch (Exception e) {
                                fatalException.setException(e);
                                stepExecution.setStatus(BatchStatus.UNKNOWN);
                                throw new AbstractStep.FatalException("Fatal error detected during update of step execution", e);
                            }
                            Object var9_13 = null;
                            if (locked) {
                                ItemOrientedStep.this.synchronizer.release(stepExecution);
                            }
                            locked = false;
                            if (nonRollbackException == null) break block19;
                        }
                        catch (Error e) {
                            ItemOrientedStep.this.processRollback(stepExecution, contribution, fatalException, transaction);
                            throw e;
                        }
                        catch (Exception e) {
                            ItemOrientedStep.this.processRollback(stepExecution, contribution, fatalException, transaction);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        if (locked) {
                            ItemOrientedStep.this.synchronizer.release(stepExecution);
                        }
                        locked = false;
                        if (nonRollbackException == null) {
                            throw throwable;
                        }
                        if (nonRollbackException instanceof Error) {
                            throw (Error)nonRollbackException;
                        }
                        throw (Exception)nonRollbackException;
                    }
                    if (nonRollbackException instanceof Error) {
                        throw (Error)nonRollbackException;
                    }
                    throw (Exception)nonRollbackException;
                }
                ItemOrientedStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                return exitStatus;
            }
        });
    }

    protected ExitStatus processChunk(final StepExecution execution, final StepContribution contribution) {
        ExitStatus result = this.chunkOperations.iterate(new RepeatCallback(){

            public ExitStatus doInIteration(RepeatContext context) throws Exception {
                if (execution.isTerminateOnly()) {
                    context.setTerminateOnly();
                }
                ItemOrientedStep.this.interruptionPolicy.checkInterrupted(execution);
                ExitStatus exitStatus = ExitStatus.FINISHED;
                exitStatus = ItemOrientedStep.this.itemHandler.handle(contribution);
                ItemOrientedStep.this.interruptionPolicy.checkInterrupted(execution);
                return exitStatus;
            }
        });
        return result;
    }

    private void processRollback(StepExecution stepExecution, StepContribution contribution, ExceptionHolder fatalException, TransactionStatus transaction) {
        block3: {
            stepExecution.incrementReadSkipCountBy(contribution.getReadSkipCount());
            stepExecution.incrementWriteSkipCountBy(contribution.getWriteSkipCount());
            stepExecution.rollback();
            try {
                this.itemHandler.reset();
                this.itemHandler.clear();
                this.transactionManager.rollback(transaction);
            }
            catch (Exception e) {
                if (fatalException.hasException()) break block3;
                fatalException.setException(e);
                throw new AbstractStep.FatalException("Failed while processing rollback", e);
            }
        }
        if (fatalException.hasException()) {
            this.getJobRepository().saveOrUpdate(stepExecution);
        }
    }

    protected void close(ExecutionContext ctx) throws Exception {
        this.stream.close(ctx);
    }

    protected void open(ExecutionContext ctx) throws Exception {
        this.stream.open(ctx);
    }

    private static class ExceptionHolder {
        private Exception exception;

        private ExceptionHolder() {
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

