/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.listener.CompositeSkipListener;
import org.springframework.batch.core.step.item.BatchListenerFactoryHelper;
import org.springframework.batch.core.step.item.ItemOrientedStep;
import org.springframework.batch.core.step.item.SimpleItemHandler;
import org.springframework.batch.core.step.item.SimpleRetryExceptionHandler;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.callback.RecoveryRetryCallback;
import org.springframework.batch.retry.policy.ExceptionClassifierRetryPolicy;
import org.springframework.batch.retry.policy.MapRetryContextCache;
import org.springframework.batch.retry.policy.NeverRetryPolicy;
import org.springframework.batch.retry.policy.RecoveryCallbackRetryPolicy;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.batch.retry.support.RetryTemplate;
import org.springframework.batch.support.ExceptionClassifier;
import org.springframework.batch.support.SubclassExceptionClassifier;

public class SkipLimitStepFactoryBean
extends SimpleStepFactoryBean {
    private int skipLimit = 0;
    private Class[] skippableExceptionClasses = new Class[]{Exception.class};
    private Class[] fatalExceptionClasses = new Class[]{Error.class};
    private ItemKeyGenerator itemKeyGenerator;
    private int cacheCapacity = 0;
    private int retryLimit = 0;
    private Class[] retryableExceptionClasses = new Class[0];
    private BackOffPolicy backOffPolicy;
    private RetryListener[] retryListeners;
    private RetryPolicy retryPolicy;

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setRetryableExceptionClasses(Class[] retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryListeners(RetryListener[] retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkippableExceptionClasses(Class[] exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setFatalExceptionClasses(Class[] fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }

    public void setItemKeyGenerator(ItemKeyGenerator itemKeyGenerator) {
        this.itemKeyGenerator = itemKeyGenerator;
    }

    protected void applyConfiguration(ItemOrientedStep step) {
        super.applyConfiguration(step);
        if (this.retryLimit > 0 || this.skipLimit > 0 || this.retryPolicy != null) {
            this.addFatalExceptionIfMissing(SkipLimitExceededException.class);
            this.addFatalExceptionIfMissing(NonSkippableException.class);
            this.addFatalExceptionIfMissing(RetryException.class);
            if (this.retryPolicy == null) {
                SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy(this.retryLimit);
                if (this.retryableExceptionClasses.length > 0) {
                    simpleRetryPolicy.setRetryableExceptionClasses(this.retryableExceptionClasses);
                }
                simpleRetryPolicy.setFatalExceptionClasses(this.fatalExceptionClasses);
                ExceptionClassifierRetryPolicy classifierRetryPolicy = new ExceptionClassifierRetryPolicy();
                SubclassExceptionClassifier exceptionClassifier = new SubclassExceptionClassifier();
                HashMap<Class, String> exceptionTypeMap = new HashMap<Class, String>();
                for (int i = 0; i < this.retryableExceptionClasses.length; ++i) {
                    Class cls = this.retryableExceptionClasses[i];
                    exceptionTypeMap.put(cls, "retry");
                }
                exceptionClassifier.setTypeMap(exceptionTypeMap);
                HashMap<String, Object> retryPolicyMap = new HashMap<String, Object>();
                retryPolicyMap.put("retry", simpleRetryPolicy);
                retryPolicyMap.put("default", new NeverRetryPolicy());
                classifierRetryPolicy.setPolicyMap(retryPolicyMap);
                classifierRetryPolicy.setExceptionClassifier((ExceptionClassifier)exceptionClassifier);
                this.retryPolicy = classifierRetryPolicy;
            }
            this.getStepOperations().setExceptionHandler((ExceptionHandler)new SimpleRetryExceptionHandler(this.retryPolicy, this.getExceptionHandler(), this.fatalExceptionClasses));
            RecoveryCallbackRetryPolicy recoveryCallbackRetryPolicy = new RecoveryCallbackRetryPolicy(this.retryPolicy){

                protected boolean recoverForException(Throwable ex) {
                    return !SkipLimitStepFactoryBean.this.getTransactionAttribute().rollbackOn(ex);
                }
            };
            if (this.cacheCapacity > 0) {
                recoveryCallbackRetryPolicy.setRetryContextCache((RetryContextCache)new MapRetryContextCache(this.cacheCapacity));
            }
            RetryTemplate retryTemplate = new RetryTemplate();
            if (this.retryListeners != null) {
                retryTemplate.setListeners(this.retryListeners);
            }
            retryTemplate.setRetryPolicy((RetryPolicy)recoveryCallbackRetryPolicy);
            if (this.retryPolicy == null && this.backOffPolicy != null) {
                retryTemplate.setBackOffPolicy(this.backOffPolicy);
            }
            ArrayList<Class> exceptions = new ArrayList<Class>(Arrays.asList(this.skippableExceptionClasses));
            LimitCheckingItemSkipPolicy readSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, exceptions, Arrays.asList(this.fatalExceptionClasses));
            exceptions.addAll(Arrays.asList(this.retryableExceptionClasses));
            LimitCheckingItemSkipPolicy writeSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, exceptions, Arrays.asList(this.fatalExceptionClasses));
            StatefulRetryItemHandler itemHandler = new StatefulRetryItemHandler(this.getItemReader(), this.getItemWriter(), (RetryOperations)retryTemplate, this.itemKeyGenerator, readSkipPolicy, writeSkipPolicy);
            itemHandler.setSkipListeners(BatchListenerFactoryHelper.getSkipListeners(this.getListeners()));
            step.setItemHandler(itemHandler);
        } else {
            step.setItemHandler(new SimpleItemHandler(this.getItemReader(), this.getItemWriter()));
        }
    }

    public void addFatalExceptionIfMissing(Class cls) {
        ArrayList<Class> fatalExceptionList = new ArrayList<Class>(Arrays.asList(this.fatalExceptionClasses));
        if (!fatalExceptionList.contains(cls)) {
            fatalExceptionList.add(cls);
        }
        this.fatalExceptionClasses = fatalExceptionList.toArray(new Class[0]);
    }

    private static class StatefulRetryItemHandler
    extends SimpleItemHandler {
        private final RetryOperations retryOperations;
        private final ItemKeyGenerator itemKeyGenerator;
        private final CompositeSkipListener listener = new CompositeSkipListener();
        private final ItemSkipPolicy readSkipPolicy;
        private final ItemSkipPolicy writeSkipPolicy;

        public StatefulRetryItemHandler(ItemReader itemReader, ItemWriter itemWriter, RetryOperations retryTemplate, ItemKeyGenerator itemKeyGenerator, ItemSkipPolicy readSkipPolicy, ItemSkipPolicy writeSkipPolicy) {
            super(itemReader, itemWriter);
            this.retryOperations = retryTemplate;
            this.itemKeyGenerator = itemKeyGenerator;
            this.readSkipPolicy = readSkipPolicy;
            this.writeSkipPolicy = writeSkipPolicy;
        }

        public void setSkipListeners(SkipListener[] listeners) {
            for (int i = 0; i < listeners.length; ++i) {
                this.registerSkipListener(listeners[i]);
            }
        }

        public void registerSkipListener(SkipListener listener) {
            this.listener.register(listener);
        }

        protected Object read(StepContribution contribution) throws Exception {
            while (true) {
                try {
                    return this.doRead();
                }
                catch (Exception e) {
                    try {
                        if (this.readSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                            contribution.incrementTemporaryReadSkipCount();
                            this.onSkipInRead(e);
                            this.logger.debug((Object)"Skipping failed input", (Throwable)e);
                            continue;
                        }
                        throw new NonSkippableException("Non-skippable exception during read", e);
                    }
                    catch (SkipLimitExceededException ex) {
                        contribution.combineSkipCounts();
                        throw ex;
                    }
                }
                break;
            }
        }

        protected void write(final Object item, final StepContribution contribution) throws Exception {
            RecoveryRetryCallback retryCallback = new RecoveryRetryCallback(item, new RetryCallback(){

                public Object doWithRetry(RetryContext context) throws Throwable {
                    StatefulRetryItemHandler.this.doWrite(item);
                    return null;
                }
            }, this.itemKeyGenerator != null ? this.itemKeyGenerator.getKey(item) : item);
            retryCallback.setRecoveryCallback(new RecoveryCallback(){

                public Object recover(RetryContext context) {
                    Throwable t = context.getLastThrowable();
                    if (!StatefulRetryItemHandler.this.writeSkipPolicy.shouldSkip(t, contribution.getStepSkipCount())) {
                        throw new NonSkippableException("Non-skippable exception on write", t);
                    }
                    StatefulRetryItemHandler.this.listener.onSkipInWrite(item, t);
                    contribution.incrementWriteSkipCount();
                    return null;
                }
            });
            this.retryOperations.execute((RetryCallback)retryCallback);
        }

        private void onSkipInRead(Exception e) {
            try {
                this.listener.onSkipInRead(e);
            }
            catch (Exception ex) {
                this.logger.debug((Object)"Error in SkipListener onSkipInReader encountered and ignored.", (Throwable)ex);
            }
        }
    }
}

