/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.batch.item.validator.ValidationException;
import org.springframework.batch.item.validator.Validator;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

class TransactionInterceptorValidator
implements Validator {
    protected Log logger = LogFactory.getLog(this.getClass());
    private final int maxCount;

    public TransactionInterceptorValidator(int maxCount) {
        this.maxCount = maxCount;
    }

    public void validate(Object value) throws ValidationException {
        Assert.notNull((Object)value, (String)"JobRepository must be provided");
        Assert.state((this.countTransactionInterceptors(value) <= this.maxCount ? 1 : 0) != 0, (String)"JobRepository has more than one transaction interceptor.  Do not declare a separate transaction advice if using the JobRepositoryFactoryBean.");
    }

    private int countTransactionInterceptors(Object object) {
        int count = 0;
        Object target = object;
        while (target instanceof Advised) {
            Advised advised = (Advised)target;
            Advisor[] interceptors = advised.getAdvisors();
            for (int i = 0; i < interceptors.length; ++i) {
                if (!(interceptors[i].getAdvice() instanceof TransactionInterceptor)) continue;
                ++count;
            }
            try {
                target = advised.getTargetSource().getTarget();
            }
            catch (Exception e) {
                this.logger.warn((Object)"Target could not be obtained from advised instance.", (Throwable)e);
            }
        }
        return count;
    }
}

