/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextJobFactory
implements JobFactory {
    private final String jobName;
    private final ApplicationContextFactory applicationContextFactory;

    public ApplicationContextJobFactory(ApplicationContextFactory applicationContextFactory, String jobName) {
        this.jobName = jobName;
        this.applicationContextFactory = applicationContextFactory;
    }

    public Job createJob() {
        ConfigurableApplicationContext context = this.applicationContextFactory.createApplicationContext();
        Job job = (Job)context.getBean(this.jobName, Job.class);
        return new ContextClosingJob(job, context);
    }

    public String getJobName() {
        return this.jobName;
    }

    private static class ContextClosingJob
    implements Job {
        private Job delegate;
        private ConfigurableApplicationContext context;

        public ContextClosingJob(Job delegate, ConfigurableApplicationContext context) {
            this.delegate = delegate;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecution execution) {
            try {
                this.delegate.execute(execution);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.context.close();
                throw throwable;
            }
            this.context.close();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public boolean isRestartable() {
            return this.delegate.isRestartable();
        }

        public JobParametersIncrementer getJobParametersIncrementer() {
            return this.delegate.getJobParametersIncrementer();
        }
    }
}

