/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.configuration.xml.DecisionParser;
import org.springframework.batch.core.configuration.xml.SplitParser;
import org.springframework.batch.core.configuration.xml.StepParser;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FlowParser {
    public AbstractBeanDefinition parse(Element element, ParserContext parserContext, String flowName) {
        ArrayList<RuntimeBeanReference> stateTransitions = new ArrayList<RuntimeBeanReference>();
        List stepElements = DomUtils.getChildElementsByTagName((Element)element, (String)"step");
        StepParser stepParser = new StepParser();
        for (Element stepElement : stepElements) {
            stateTransitions.addAll(stepParser.parse(stepElement, parserContext));
        }
        List decisionElements = DomUtils.getChildElementsByTagName((Element)element, (String)"decision");
        DecisionParser decisionParser = new DecisionParser();
        for (Element stepElement : decisionElements) {
            stateTransitions.addAll(decisionParser.parse(stepElement, parserContext));
        }
        List splitElements = DomUtils.getChildElementsByTagName((Element)element, (String)"split");
        SplitParser splitParser = new SplitParser();
        for (Element stepElement : splitElements) {
            stateTransitions.addAll(splitParser.parse(stepElement, parserContext));
        }
        BeanDefinitionBuilder flowBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleFlow.class);
        flowBuilder.addConstructorArgValue((Object)flowName);
        ManagedList managedList = new ManagedList();
        boolean dummy = managedList.addAll(stateTransitions);
        flowBuilder.addPropertyValue("stateTransitions", (Object)managedList);
        AbstractBeanDefinition flowDef = flowBuilder.getBeanDefinition();
        parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)flowDef);
        return flowDef;
    }
}

