/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.job.flow.support.StateTransition;
import org.springframework.batch.core.job.flow.support.state.EndState;
import org.springframework.batch.core.job.flow.support.state.StepState;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepParser {
    private static int endCounter = 0;

    public Collection<RuntimeBeanReference> parse(Element element, ParserContext parserContext) {
        RuntimeBeanReference stateDef = new RuntimeBeanReference(element.getAttribute("name"));
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition(StepState.class);
        stateBuilder.addConstructorArgValue((Object)stateDef);
        return StepParser.getNextElements(parserContext, (BeanDefinition)stateBuilder.getBeanDefinition(), element);
    }

    public static Collection<RuntimeBeanReference> getNextElements(ParserContext parserContext, BeanDefinition stateDef, Element element) {
        ArrayList<RuntimeBeanReference> list = new ArrayList<RuntimeBeanReference>();
        String shortNextAttribute = element.getAttribute("next");
        boolean hasNextAttribute = StringUtils.hasText((String)shortNextAttribute);
        if (hasNextAttribute) {
            list.add(StepParser.getStateTransitionReference(parserContext, stateDef, null, shortNextAttribute));
        }
        List nextElements = DomUtils.getChildElementsByTagName((Element)element, (String)"next");
        List stopElements = DomUtils.getChildElementsByTagName((Element)element, (String)"stop");
        nextElements.addAll(stopElements);
        List endElements = DomUtils.getChildElementsByTagName((Element)element, (String)"end");
        nextElements.addAll(endElements);
        for (Element nextElement : nextElements) {
            String onAttribute = nextElement.getAttribute("on");
            String nextAttribute = nextElement.getAttribute("to");
            if (hasNextAttribute && onAttribute.equals("*")) {
                throw new BeanCreationException("Duplicate transition pattern found for '*' (only specify one of next= attribute at step level and next element with on='*')");
            }
            String name = nextElement.getNodeName();
            if ("stop".equals(name) || "end".equals(name)) {
                String statusName = nextElement.getAttribute("status");
                BatchStatus status = StringUtils.hasText((String)statusName) ? BatchStatus.valueOf(statusName) : BatchStatus.STOPPED;
                String nextOnEnd = StringUtils.hasText((String)statusName) ? null : nextAttribute;
                BeanDefinitionBuilder endBuilder = BeanDefinitionBuilder.genericBeanDefinition(EndState.class);
                endBuilder.addConstructorArgValue((Object)status);
                String endName = "end" + endCounter;
                ++endCounter;
                endBuilder.addConstructorArgValue((Object)endName);
                list.add(StepParser.getStateTransitionReference(parserContext, (BeanDefinition)endBuilder.getBeanDefinition(), onAttribute, nextOnEnd));
                nextAttribute = endName;
            }
            list.add(StepParser.getStateTransitionReference(parserContext, stateDef, onAttribute, nextAttribute));
        }
        if (list.isEmpty() && !hasNextAttribute) {
            list.add(StepParser.getStateTransitionReference(parserContext, stateDef, null, null));
        }
        return list;
    }

    public static RuntimeBeanReference getStateTransitionReference(ParserContext parserContext, BeanDefinition stateDefinition, String on, String next) {
        BeanDefinitionBuilder nextBuilder = BeanDefinitionBuilder.genericBeanDefinition(StateTransition.class);
        nextBuilder.addConstructorArgValue((Object)stateDefinition);
        if (StringUtils.hasText((String)on)) {
            nextBuilder.addConstructorArgValue((Object)on);
        }
        if (StringUtils.hasText((String)next)) {
            nextBuilder.setFactoryMethod("createStateTransition");
            nextBuilder.addConstructorArgValue((Object)next);
        } else {
            nextBuilder.setFactoryMethod("createEndStateTransition");
        }
        AbstractBeanDefinition nextDef = nextBuilder.getBeanDefinition();
        String nextDefName = parserContext.getReaderContext().generateBeanName((BeanDefinition)nextDef);
        BeanComponentDefinition nextDefComponent = new BeanComponentDefinition((BeanDefinition)nextDef, nextDefName);
        parserContext.registerBeanComponent(nextDefComponent);
        return new RuntimeBeanReference(nextDefName);
    }
}

