/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.explore.support;

import java.util.List;
import java.util.Set;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJobExplorer
implements JobExplorer {
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;

    SimpleJobExplorer() {
    }

    public SimpleJobExplorer(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(jobInstance);
        for (JobExecution jobExecution : executions) {
            this.getJobExecutionDependencies(jobExecution);
        }
        return executions;
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        Set<JobExecution> executions = this.jobExecutionDao.findRunningJobExecutions(jobName);
        for (JobExecution jobExecution : executions) {
            this.getJobExecutionDependencies(jobExecution);
        }
        return executions;
    }

    @Override
    public JobExecution getJobExecution(Long executionId) {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(executionId);
        this.getJobExecutionDependencies(jobExecution);
        return jobExecution;
    }

    @Override
    public StepExecution getStepExecution(Long executionId, String stepName) {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(executionId);
        return this.stepExecutionDao.getStepExecution(jobExecution, stepName);
    }

    @Override
    public JobInstance getJobInstance(Long instanceId) {
        return this.jobInstanceDao.getJobInstance(instanceId);
    }

    @Override
    public List<JobInstance> getLastJobInstances(String jobName, int count) {
        return this.jobInstanceDao.getLastJobInstances(jobName, count);
    }

    private void getJobExecutionDependencies(JobExecution jobExecution) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobExecution);
        this.stepExecutionDao.getStepExecutions(jobExecution);
        jobExecution.setJobInstance(jobInstance);
    }
}

