/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.CompositeExecutionJobListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractJob
implements Job,
BeanNameAware,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(AbstractJob.class);
    private String name;
    private boolean restartable = false;
    private JobRepository jobRepository;
    private CompositeExecutionJobListener listener = new CompositeExecutionJobListener();
    private JobParametersIncrementer jobParametersIncrementer;

    public AbstractJob() {
    }

    public AbstractJob(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository must be set");
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    public JobParametersIncrementer getJobParametersIncrementer() {
        return this.jobParametersIncrementer;
    }

    public void setJobExecutionListeners(JobExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.listener.register(listeners[i]);
        }
    }

    public void registerJobExecutionListener(JobExecutionListener listener) {
        this.listener.register(listener);
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    protected abstract StepExecution doExecute(JobExecution var1) throws JobExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute(JobExecution execution) {
        block20: {
            block18: {
                if (execution.getStatus() != BatchStatus.STOPPING) {
                    execution.setStartTime(new Date());
                    if (!execution.isPaused()) {
                        this.updateStatus(execution, BatchStatus.STARTED);
                    }
                    this.listener.beforeJob(execution);
                    StepExecution lastStepExecution = this.doExecute(execution);
                    if (lastStepExecution != null) {
                        if (!execution.isPaused()) {
                            execution.setStatus(lastStepExecution.getStatus());
                        }
                        execution.setExitStatus(lastStepExecution.getExitStatus());
                    }
                    break block18;
                }
                execution.setStatus(BatchStatus.STOPPED);
                execution.setExitStatus(ExitStatus.FINISHED);
            }
            Object var4_5 = null;
            if (execution.getStepExecutions().isEmpty()) {
                execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
            }
            execution.setEndTime(new Date());
            try {
                this.listener.afterJob(execution);
            }
            catch (Exception e2) {
                logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
            }
            this.jobRepository.update(execution);
            {
                break block20;
                catch (JobInterruptedException e) {
                    logger.error((Object)e);
                    execution.setExitStatus(ExitStatus.FAILED);
                    execution.setStatus(BatchStatus.STOPPED);
                    execution.addFailureException(e);
                    Object var4_6 = null;
                    if (execution.getStepExecutions().isEmpty()) {
                        execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
                    }
                    execution.setEndTime(new Date());
                    try {
                        this.listener.afterJob(execution);
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
                    }
                    this.jobRepository.update(execution);
                    break block20;
                }
                catch (Throwable t) {
                    logger.error((Object)t);
                    execution.setExitStatus(ExitStatus.FAILED);
                    execution.setStatus(BatchStatus.FAILED);
                    execution.addFailureException(t);
                    Object var4_7 = null;
                    if (execution.getStepExecutions().isEmpty()) {
                        execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
                    }
                    execution.setEndTime(new Date());
                    try {
                        this.listener.afterJob(execution);
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
                    }
                    this.jobRepository.update(execution);
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (execution.getStepExecutions().isEmpty()) {
                    execution.setExitStatus(ExitStatus.NOOP.addExitDescription("All steps already completed or no steps configured for this job."));
                }
                execution.setEndTime(new Date());
                try {
                    this.listener.afterJob(execution);
                }
                catch (Exception e2) {
                    logger.error((Object)"Exception encountered in afterStep callback", (Throwable)e2);
                }
                this.jobRepository.update(execution);
                throw throwable;
            }
        }
    }

    protected final StepExecution handleStep(Step step, JobExecution execution) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
        if (execution.getStatus() == BatchStatus.STOPPING || execution.getStatus() == BatchStatus.STOPPED) {
            throw new JobInterruptedException("JobExecution interrupted.");
        }
        JobInstance jobInstance = execution.getJobInstance();
        StepExecution currentStepExecution = null;
        if (this.shouldStart(jobInstance, step)) {
            boolean isRestart;
            currentStepExecution = execution.createStepExecution(step.getName());
            StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step.getName());
            boolean bl = isRestart = lastStepExecution != null && !lastStepExecution.getStatus().equals((Object)BatchStatus.COMPLETED);
            if (isRestart) {
                currentStepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
            } else {
                currentStepExecution.setExecutionContext(new ExecutionContext());
            }
            this.jobRepository.add(currentStepExecution);
            step.execute(currentStepExecution);
            if (currentStepExecution.getStatus() == BatchStatus.STOPPED || currentStepExecution.getStatus() == BatchStatus.STOPPING) {
                throw new JobInterruptedException("Job interrupted by step execution");
            }
        }
        return currentStepExecution;
    }

    private boolean shouldStart(JobInstance jobInstance, Step step) throws JobRestartException, StartLimitExceededException {
        StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, step.getName());
        BatchStatus stepStatus = lastStepExecution == null ? BatchStatus.STARTING : lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobRestartException("Cannot restart step from UNKNOWN status.  The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED && !step.isAllowStartIfComplete()) {
            return false;
        }
        if (this.jobRepository.getStepExecutionCount(jobInstance, step.getName()) < step.getStartLimit()) {
            return true;
        }
        throw new StartLimitExceededException("Maximum start limit exceeded for step: " + step.getName() + "StartMax: " + step.getStartLimit());
    }

    private void updateStatus(JobExecution jobExecution, BatchStatus status) {
        jobExecution.setStatus(status);
        this.jobRepository.update(jobExecution);
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + ": [name=" + this.name + "]";
    }
}

