/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.lang.reflect.Method;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.annotation.AfterJob;
import org.springframework.batch.core.annotation.BeforeJob;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;

public class JobListenerAnnotationBeanPostProcessor
implements BeanPostProcessor {
    private AbstractJob job;

    public JobListenerAnnotationBeanPostProcessor(AbstractJob job) {
        this.job = job;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return null;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        for (Method method : bean.getClass().getMethods()) {
            AfterJob afterJob;
            BeforeJob beforeJob = (BeforeJob)AnnotationUtils.findAnnotation((Method)method, BeforeJob.class);
            if (beforeJob != null) {
                BeforeJobProxy listener = new BeforeJobProxy(method, bean, this.supportsJobExecutionPassing(method));
                this.job.registerJobExecutionListener(listener);
            }
            if ((afterJob = (AfterJob)AnnotationUtils.findAnnotation((Method)method, AfterJob.class)) == null) continue;
            AfterJobProxy listener = new AfterJobProxy(method, bean, this.supportsJobExecutionPassing(method));
            this.job.registerJobExecutionListener(listener);
        }
        return null;
    }

    private boolean supportsJobExecutionPassing(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 0 || parameters.length > 1) {
            return false;
        }
        Class<?> parameter = parameters[0];
        return parameter == JobExecution.class;
    }

    private class AfterJobProxy
    extends JobExecutionListenerSupport {
        Method method;
        Object bean;
        boolean passThroughExecution;

        public AfterJobProxy(Method method, Object bean, boolean passThroughExecution) {
            this.method = method;
            this.bean = bean;
            this.passThroughExecution = passThroughExecution;
        }

        public void afterJob(JobExecution jobExecution) {
            try {
                if (this.passThroughExecution) {
                    this.method.invoke(this.bean, jobExecution);
                } else {
                    this.method.invoke(this.bean, new Object[0]);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to invoke annotated method: [" + this.method, ex);
            }
        }
    }

    private class BeforeJobProxy
    extends JobExecutionListenerSupport {
        Method method;
        Object bean;
        boolean passThroughExecution;

        public BeforeJobProxy(Method method, Object bean, boolean passThroughExecution) {
            this.method = method;
            this.bean = bean;
            this.passThroughExecution = passThroughExecution;
        }

        public void beforeJob(JobExecution jobExecution) {
            try {
                if (this.passThroughExecution) {
                    this.method.invoke(this.bean, jobExecution);
                } else {
                    this.method.invoke(this.bean, new Object[0]);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to invoke annotated method: [" + this.method, ex);
            }
        }
    }
}

