/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowExecution
implements Comparable<FlowExecution> {
    public static final String COMPLETED = Status.COMPLETED.toString();
    public static final String PAUSED = Status.PAUSED.toString();
    public static final String FAILED = Status.FAILED.toString();
    public static final String UNKNOWN = Status.UNKNOWN.toString();
    private final String name;
    private final String status;

    public FlowExecution(String name, String status) {
        this.name = name;
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public int compareTo(FlowExecution other) {
        Status two;
        Status one = Status.match(this.getStatus());
        int comparison = one.compareTo(two = Status.match(other.getStatus()));
        if (comparison == 0) {
            return this.getStatus().compareTo(other.getStatus());
        }
        return comparison;
    }

    public String toString() {
        return String.format("FlowExecution: name=%s, status=%s", this.name, this.status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        COMPLETED,
        PAUSED,
        FAILED,
        UNKNOWN;


        static Status match(String value) {
            for (int i = 0; i < Status.values().length; ++i) {
                Status status = Status.values()[i];
                if (!value.startsWith(status.toString())) continue;
                return status;
            }
            return COMPLETED;
        }
    }
}

