/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StartLimitExceededException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.util.Assert;

public class FlowJob
extends AbstractJob {
    private Flow flow;

    public FlowJob() {
    }

    public FlowJob(String name) {
        super(name);
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    protected StepExecution doExecute(JobExecution execution) throws JobExecutionException {
        try {
            FlowExecution result = this.flow.start(new JobFlowExecutor(execution));
            return this.getLastStepExecution(execution, result);
        }
        catch (FlowExecutionException e) {
            if (e.getCause() instanceof JobExecutionException) {
                throw (JobExecutionException)e.getCause();
            }
            throw new JobExecutionException("Flow execution ended unexpectedly", e);
        }
    }

    private StepExecution getLastStepExecution(JobExecution execution, FlowExecution result) {
        StepExecution value = null;
        StepExecution backup = null;
        for (StepExecution stepExecution : execution.getStepExecutions()) {
            if (stepExecution.getStepName().equals(result.getName()) && stepExecution.getExitStatus().getExitCode().equals(result.getStatus())) {
                value = stepExecution;
            }
            if (!this.isLater(backup, stepExecution)) continue;
            backup = stepExecution;
        }
        if (value == null) {
            value = backup;
        }
        Assert.state((value != null ? 1 : 0) != 0, (String)String.format("Could not locate step execution matching expected properties: flowExecution=%s, stepExecutions=%s", result, execution.getStepExecutions()));
        return value;
    }

    private boolean isLater(StepExecution first, StepExecution second) {
        if (first == null) {
            return true;
        }
        if (first.getEndTime() == null) {
            return first.getStartTime().after(second.getStartTime());
        }
        if (second.getEndTime() == null) {
            return false;
        }
        return first.getEndTime().after(second.getEndTime());
    }

    private class JobFlowExecutor
    implements FlowExecutor {
        private final ThreadLocal<StepExecution> stepExecutionHolder = new ThreadLocal();
        private final JobExecution execution;

        private JobFlowExecutor(JobExecution execution) {
            this.execution = execution;
            this.stepExecutionHolder.set(null);
        }

        public String executeStep(Step step) throws JobInterruptedException, JobRestartException, StartLimitExceededException {
            StepExecution stepExecution = FlowJob.this.handleStep(step, this.execution);
            this.stepExecutionHolder.set(stepExecution);
            return stepExecution == null ? FlowExecution.COMPLETED : stepExecution.getExitStatus().getExitCode();
        }

        public JobExecution getJobExecution() {
            return this.execution;
        }

        public StepExecution getStepExecution() {
            return this.stepExecutionHolder.get();
        }

        public void close(FlowExecution result) {
            this.stepExecutionHolder.set(null);
        }
    }
}

