/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowExecution;
import org.springframework.batch.core.job.flow.FlowExecutionException;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.support.state.AbstractState;
import org.springframework.batch.core.job.flow.support.state.FlowExecutionAggregator;
import org.springframework.batch.core.job.flow.support.state.MaxValueFlowExecutionAggregator;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.task.TaskRejectedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitState
extends AbstractState {
    private final Collection<Flow> flows;
    private TaskExecutor taskExecutor = new SyncTaskExecutor();
    private FlowExecutionAggregator aggregator = new MaxValueFlowExecutionAggregator();

    public SplitState(Collection<Flow> flows, String name) {
        super(name);
        this.flows = flows;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Override
    public String handle(final FlowExecutor executor) throws Exception {
        ArrayList<FutureTask> tasks = new ArrayList<FutureTask>();
        for (final Flow flow : this.flows) {
            FutureTask task = new FutureTask(new Callable<FlowExecution>(){

                @Override
                public FlowExecution call() throws Exception {
                    return flow.start(executor);
                }
            });
            tasks.add(task);
            try {
                this.taskExecutor.execute((Runnable)task);
            }
            catch (TaskRejectedException e) {
                throw new FlowExecutionException("TaskExecutor rejected task for flow=" + flow.getName());
            }
        }
        ArrayList<FlowExecution> results = new ArrayList<FlowExecution>();
        for (FutureTask task : tasks) {
            results.add((FlowExecution)task.get());
        }
        return this.aggregator.aggregate(results);
    }
}

