/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.launch.support.ExitCodeMapper;
import org.springframework.batch.repeat.ExitStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJvmExitCodeMapper
implements ExitCodeMapper {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Map<String, Integer> mapping = new HashMap<String, Integer>();

    public SimpleJvmExitCodeMapper() {
        this.mapping.put(ExitStatus.FINISHED.getExitCode(), new Integer(0));
        this.mapping.put(ExitStatus.FAILED.getExitCode(), new Integer(1));
        this.mapping.put("JOB_NOT_PROVIDED", new Integer(2));
        this.mapping.put("NO_SUCH_JOB", new Integer(2));
    }

    public Map<String, Integer> getMapping() {
        return this.mapping;
    }

    public void setMapping(Map<String, Integer> exitCodeMap) {
        this.mapping.putAll(exitCodeMap);
    }

    @Override
    public int intValue(String exitCode) {
        Integer statusCode = null;
        try {
            statusCode = this.mapping.get(exitCode);
        }
        catch (RuntimeException ex) {
            this.logger.fatal((Object)"Error mapping exit code, generic exit status returned.", (Throwable)ex);
        }
        return statusCode != null ? statusCode : 1;
    }
}

