/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.Collection;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.util.Assert;

public class PartitionStep
extends AbstractStep {
    private StepExecutionSplitter stepExecutionSplitter;
    private PartitionHandler partitionHandler;
    private StepExecutionAggregator aggregator = new StepExecutionAggregator();

    public void setPartitionHandler(PartitionHandler partitionHandler) {
        this.partitionHandler = partitionHandler;
    }

    public void setStepExecutionSplitter(StepExecutionSplitter stepExecutionSplitter) {
        this.stepExecutionSplitter = stepExecutionSplitter;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.stepExecutionSplitter, (String)"StepExecutionSplitter must be provided");
        Assert.notNull((Object)this.partitionHandler, (String)"PartitionHandler must be provided");
        super.afterPropertiesSet();
    }

    protected ExitStatus doExecute(StepExecution stepExecution) throws Exception {
        Collection<StepExecution> executions = this.partitionHandler.handle(this.stepExecutionSplitter, stepExecution);
        this.aggregator.aggregate(stepExecution, executions);
        if (stepExecution.getStatus() != BatchStatus.COMPLETED) {
            throw new JobExecutionException("Partition handler returned an incomplete step");
        }
        return stepExecution.getExitStatus();
    }
}

