/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.NoSuchObjectException;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcJobExecutionDao
extends AbstractJdbcBatchMetadataDao
implements JobExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JdbcJobExecutionDao.class);
    private static final String SAVE_JOB_EXECUTION = "INSERT into %PREFIX%JOB_EXECUTION(JOB_EXECUTION_ID, JOB_INSTANCE_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, VERSION, CREATE_TIME, LAST_UPDATED) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String CHECK_JOB_EXECUTION_EXISTS = "SELECT COUNT(*) FROM %PREFIX%JOB_EXECUTION WHERE JOB_EXECUTION_ID = ?";
    private static final String GET_STATUS = "SELECT STATUS from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String UPDATE_JOB_EXECUTION = "UPDATE %PREFIX%JOB_EXECUTION set START_TIME = ?, END_TIME = ?,  STATUS = ?, CONTINUABLE = ?, EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ?, CREATE_TIME = ?, LAST_UPDATED = ? where JOB_EXECUTION_ID = ?";
    private static final String FIND_JOB_EXECUTIONS = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ? order by JOB_EXECUTION_ID desc";
    private static final String GET_LAST_EXECUTION = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ? and CREATE_TIME = (SELECT max(CREATE_TIME) from %PREFIX%JOB_EXECUTION where JOB_INSTANCE_ID = ?)";
    private static final String GET_EXECUTION_BY_ID = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED from %PREFIX%JOB_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String GET_RUNNING_EXECUTIONS = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, JOB_INSTANCE_ID from %PREFIX%JOB_EXECUTION where END_TIME is NULL order by JOB_EXECUTION_ID desc";
    private int exitMessageLength = 2500;
    private DataFieldMaxValueIncrementer jobExecutionIncrementer;

    public void setExitMessageLength(int exitMessageLength) {
        this.exitMessageLength = exitMessageLength;
    }

    public void setJobExecutionIncrementer(DataFieldMaxValueIncrementer jobExecutionIncrementer) {
        this.jobExecutionIncrementer = jobExecutionIncrementer;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.jobExecutionIncrementer);
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance job) {
        Assert.notNull((Object)job, (String)"Job cannot be null.");
        Assert.notNull((Object)job.getId(), (String)"Job Id cannot be null.");
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_EXECUTIONS), (ParameterizedRowMapper)new JobExecutionRowMapper(job), new Object[]{job.getId()});
    }

    @Override
    public void saveJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        jobExecution.setId(new Long(this.jobExecutionIncrementer.nextLongValue()));
        Object[] parameters = new Object[]{jobExecution.getId(), jobExecution.getJobId(), jobExecution.getStartTime(), jobExecution.getEndTime(), jobExecution.getStatus().toString(), jobExecution.getExitStatus().isContinuable() ? "Y" : "N", jobExecution.getExitStatus().getExitCode(), jobExecution.getExitStatus().getExitDescription(), jobExecution.getVersion(), jobExecution.getCreateTime(), jobExecution.getLastUpdated()};
        this.getJdbcTemplate().getJdbcOperations().update(this.getQuery(SAVE_JOB_EXECUTION), parameters, new int[]{4, 4, 93, 93, 12, 1, 12, 12, 4, 93, 93});
    }

    private void validateJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution);
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution Job-Id cannot be null.");
        Assert.notNull((Object)((Object)jobExecution.getStatus()), (String)"JobExecution status cannot be null.");
        Assert.notNull((Object)jobExecution.getCreateTime(), (String)"JobExecution create time cannot be null");
    }

    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        String exitDescription = jobExecution.getExitStatus().getExitDescription();
        if (exitDescription != null && exitDescription.length() > this.exitMessageLength) {
            exitDescription = exitDescription.substring(0, this.exitMessageLength);
            logger.debug((Object)("Truncating long message before update of JobExecution: " + jobExecution));
        }
        Object[] parameters = new Object[]{jobExecution.getStartTime(), jobExecution.getEndTime(), jobExecution.getStatus().toString(), jobExecution.getExitStatus().isContinuable() ? "Y" : "N", jobExecution.getExitStatus().getExitCode(), exitDescription, jobExecution.getVersion(), jobExecution.getCreateTime(), jobExecution.getLastUpdated(), jobExecution.getId()};
        if (jobExecution.getId() == null) {
            throw new IllegalArgumentException("JobExecution ID cannot be null.  JobExecution must be saved before it can be updated.");
        }
        if (this.getJdbcTemplate().queryForInt(this.getQuery(CHECK_JOB_EXECUTION_EXISTS), new Object[]{jobExecution.getId()}) != 1) {
            throw new NoSuchObjectException("Invalid JobExecution, ID " + jobExecution.getId() + " not found.");
        }
        this.getJdbcTemplate().getJdbcOperations().update(this.getQuery(UPDATE_JOB_EXECUTION), parameters, new int[]{93, 93, 12, 1, 12, 12, 4, 93, 93, 4});
    }

    @Override
    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        Long id = jobInstance.getId();
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_LAST_EXECUTION), (ParameterizedRowMapper)new JobExecutionRowMapper(jobInstance), new Object[]{id, id});
        Assert.state((executions.size() <= 1 ? 1 : 0) != 0, (String)"There must be at most one latest job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return (JobExecution)executions.get(0);
    }

    @Override
    public JobExecution getJobExecution(Long executionId) {
        try {
            JobExecution jobExecution = (JobExecution)this.getJdbcTemplate().queryForObject(this.getQuery(GET_EXECUTION_BY_ID), (ParameterizedRowMapper)new JobExecutionRowMapper(), new Object[]{executionId});
            return jobExecution;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        final HashSet<JobExecution> result = new HashSet<JobExecution>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                JobExecutionRowMapper mapper = new JobExecutionRowMapper();
                result.add(mapper.mapRow(rs, 0));
            }
        };
        this.getJdbcTemplate().getJdbcOperations().query(this.getQuery(GET_RUNNING_EXECUTIONS), handler);
        return result;
    }

    @Override
    public void synchronizeStatus(JobExecution jobExecution) {
        String status = (String)this.getJdbcTemplate().queryForObject(this.getQuery(GET_STATUS), String.class, new Object[]{jobExecution.getId()});
        jobExecution.setStatus(BatchStatus.valueOf(status));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JobExecutionRowMapper
    implements ParameterizedRowMapper<JobExecution> {
        private JobInstance jobInstance;

        public JobExecutionRowMapper() {
        }

        public JobExecutionRowMapper(JobInstance jobInstance) {
            this.jobInstance = jobInstance;
        }

        public JobExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = new Long(rs.getLong(1));
            JobExecution jobExecution = this.jobInstance == null ? new JobExecution(id) : new JobExecution(this.jobInstance, id);
            jobExecution.setStartTime(rs.getTimestamp(2));
            jobExecution.setEndTime(rs.getTimestamp(3));
            jobExecution.setStatus(BatchStatus.valueOf(rs.getString(4)));
            jobExecution.setExitStatus(new ExitStatus("Y".equals(rs.getString(5)), rs.getString(6), rs.getString(7)));
            jobExecution.setCreateTime(rs.getTimestamp(8));
            jobExecution.setLastUpdated(rs.getTimestamp(9));
            return jobExecution;
        }
    }
}

