/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcStepExecutionDao
extends AbstractJdbcBatchMetadataDao
implements StepExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JdbcStepExecutionDao.class);
    private static final String SAVE_STEP_EXECUTION = "INSERT into %PREFIX%STEP_EXECUTION(STEP_EXECUTION_ID, VERSION, STEP_NAME, JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, COMMIT_COUNT, READ_COUNT, FILTER_COUNT, WRITE_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, READ_SKIP_COUNT, WRITE_SKIP_COUNT, PROCESS_SKIP_COUNT, ROLLBACK_COUNT, LAST_UPDATED) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_STEP_EXECUTION = "UPDATE %PREFIX%STEP_EXECUTION set START_TIME = ?, END_TIME = ?, STATUS = ?, COMMIT_COUNT = ?, READ_COUNT = ?, FILTER_COUNT = ?, WRITE_COUNT = ?, CONTINUABLE = ? , EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ?, READ_SKIP_COUNT = ?, WRITE_SKIP_COUNT = ?, ROLLBACK_COUNT = ?, LAST_UPDATED = ? where STEP_EXECUTION_ID = ? and VERSION = ?";
    private static final String GET_RAW_STEP_EXECUTIONS = "SELECT STEP_EXECUTION_ID, STEP_NAME, START_TIME, END_TIME, STATUS, COMMIT_COUNT, READ_COUNT, FILTER_COUNT, WRITE_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, READ_SKIP_COUNT, WRITE_SKIP_COUNT, PROCESS_SKIP_COUNT, ROLLBACK_COUNT, LAST_UPDATED, VERSION from %PREFIX%STEP_EXECUTION where JOB_EXECUTION_ID = ?";
    private static final String GET_STEP_EXECUTIONS = "SELECT STEP_EXECUTION_ID, STEP_NAME, START_TIME, END_TIME, STATUS, COMMIT_COUNT, READ_COUNT, FILTER_COUNT, WRITE_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, READ_SKIP_COUNT, WRITE_SKIP_COUNT, PROCESS_SKIP_COUNT, ROLLBACK_COUNT, LAST_UPDATED, VERSION from %PREFIX%STEP_EXECUTION where JOB_EXECUTION_ID = ? order by STEP_EXECUTION_ID";
    private static final String GET_STEP_EXECUTION = "SELECT STEP_EXECUTION_ID, STEP_NAME, START_TIME, END_TIME, STATUS, COMMIT_COUNT, READ_COUNT, FILTER_COUNT, WRITE_COUNT, CONTINUABLE, EXIT_CODE, EXIT_MESSAGE, READ_SKIP_COUNT, WRITE_SKIP_COUNT, PROCESS_SKIP_COUNT, ROLLBACK_COUNT, LAST_UPDATED, VERSION from %PREFIX%STEP_EXECUTION where JOB_EXECUTION_ID = ? and STEP_NAME = ?";
    private static final String CURRENT_VERSION_STEP_EXECUTION = "SELECT VERSION FROM %PREFIX%STEP_EXECUTION WHERE STEP_EXECUTION_ID=?";
    private int exitMessageLength = 2500;
    private DataFieldMaxValueIncrementer stepExecutionIncrementer;

    public void setExitMessageLength(int exitMessageLength) {
        this.exitMessageLength = exitMessageLength;
    }

    public void setStepExecutionIncrementer(DataFieldMaxValueIncrementer stepExecutionIncrementer) {
        this.stepExecutionIncrementer = stepExecutionIncrementer;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.stepExecutionIncrementer, (String)"StepExecutionIncrementer cannot be null.");
    }

    @Override
    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isNull((Object)stepExecution.getId(), (String)"to-be-saved (not updated) StepExecution can't already have an id assigned");
        Assert.isNull((Object)stepExecution.getVersion(), (String)"to-be-saved (not updated) StepExecution can't already have a version assigned");
        this.validateStepExecution(stepExecution);
        String exitDescription = this.truncateExitDescription(stepExecution.getExitStatus().getExitDescription());
        stepExecution.setId(new Long(this.stepExecutionIncrementer.nextLongValue()));
        stepExecution.incrementVersion();
        Object[] parameters = new Object[]{stepExecution.getId(), stepExecution.getVersion(), stepExecution.getStepName(), stepExecution.getJobExecutionId(), stepExecution.getStartTime(), stepExecution.getEndTime(), stepExecution.getStatus().toString(), stepExecution.getCommitCount(), stepExecution.getReadCount(), stepExecution.getFilterCount(), stepExecution.getWriteCount(), stepExecution.getExitStatus().isContinuable() ? "Y" : "N", stepExecution.getExitStatus().getExitCode(), exitDescription, stepExecution.getReadSkipCount(), stepExecution.getWriteSkipCount(), stepExecution.getProcessSkipCount(), stepExecution.getRollbackCount(), stepExecution.getLastUpdated()};
        this.getJdbcTemplate().getJdbcOperations().update(this.getQuery(SAVE_STEP_EXECUTION), parameters, new int[]{4, 4, 12, 4, 93, 93, 12, 4, 4, 4, 4, 1, 12, 12, 4, 4, 4, 4, 93});
    }

    private void validateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution);
        Assert.notNull((Object)stepExecution.getStepName(), (String)"StepExecution step name cannot be null.");
        Assert.notNull((Object)stepExecution.getStartTime(), (String)"StepExecution start time cannot be null.");
        Assert.notNull((Object)((Object)stepExecution.getStatus()), (String)"StepExecution status cannot be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStepExecution(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull((Object)stepExecution.getId(), (String)"StepExecution Id cannot be null. StepExecution must saved before it can be updated.");
        String exitDescription = this.truncateExitDescription(stepExecution.getExitStatus().getExitDescription());
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            Integer version = new Integer(stepExecution.getVersion() + 1);
            Object[] parameters = new Object[]{stepExecution.getStartTime(), stepExecution.getEndTime(), stepExecution.getStatus().toString(), stepExecution.getCommitCount(), stepExecution.getReadCount(), stepExecution.getFilterCount(), stepExecution.getWriteCount(), stepExecution.getExitStatus().isContinuable() ? "Y" : "N", stepExecution.getExitStatus().getExitCode(), exitDescription, version, stepExecution.getReadSkipCount(), stepExecution.getWriteSkipCount(), stepExecution.getRollbackCount(), stepExecution.getLastUpdated(), stepExecution.getId(), stepExecution.getVersion()};
            int count = this.getJdbcTemplate().getJdbcOperations().update(this.getQuery(UPDATE_STEP_EXECUTION), parameters, new int[]{93, 93, 12, 4, 4, 4, 4, 1, 12, 12, 4, 4, 4, 4, 93, 4, 4});
            if (count == 0) {
                int curentVersion = this.getJdbcTemplate().queryForInt(this.getQuery(CURRENT_VERSION_STEP_EXECUTION), new Object[]{stepExecution.getId()});
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + curentVersion);
            }
            stepExecution.incrementVersion();
        }
    }

    private String truncateExitDescription(String description) {
        if (description != null && description.length() > this.exitMessageLength) {
            logger.debug((Object)("Truncating long message before update of StepExecution, original message is: " + description));
            return description.substring(0, this.exitMessageLength);
        }
        return description;
    }

    @Override
    public StepExecution getStepExecution(JobExecution jobExecution, String stepName) {
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_STEP_EXECUTION), (ParameterizedRowMapper)new StepExecutionRowMapper(jobExecution), new Object[]{jobExecution.getId(), stepName});
        Assert.state((executions.size() <= 1 ? 1 : 0) != 0, (String)"There can be at most one step execution with given name for single job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return (StepExecution)executions.get(0);
    }

    @Override
    public List<StepExecution> getStepExecutions(JobExecution jobExecution) {
        List executions = this.getJdbcTemplate().query(this.getQuery(GET_STEP_EXECUTIONS), (ParameterizedRowMapper)new StepExecutionRowMapper(jobExecution), new Object[]{jobExecution.getId()});
        return executions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StepExecutionRowMapper
    implements ParameterizedRowMapper<StepExecution> {
        private final JobExecution jobExecution;

        public StepExecutionRowMapper(JobExecution jobExecution) {
            this.jobExecution = jobExecution;
        }

        public StepExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            StepExecution stepExecution = new StepExecution(rs.getString(2), this.jobExecution, rs.getLong(1));
            stepExecution.setStartTime(rs.getTimestamp(3));
            stepExecution.setEndTime(rs.getTimestamp(4));
            stepExecution.setStatus(BatchStatus.valueOf(rs.getString(5)));
            stepExecution.setCommitCount(rs.getInt(6));
            stepExecution.setReadCount(rs.getInt(7));
            stepExecution.setFilterCount(rs.getInt(8));
            stepExecution.setWriteCount(rs.getInt(9));
            stepExecution.setExitStatus(new ExitStatus("Y".equals(rs.getString(10)), rs.getString(11), rs.getString(12)));
            stepExecution.setReadSkipCount(rs.getInt(13));
            stepExecution.setWriteSkipCount(rs.getInt(14));
            stepExecution.setProcessSkipCount(rs.getInt(15));
            stepExecution.setRollbackCount(rs.getInt(16));
            stepExecution.setLastUpdated(rs.getTimestamp(17));
            stepExecution.setVersion(rs.getInt(18));
            return stepExecution;
        }
    }
}

