/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapJobExecutionDao
implements JobExecutionDao {
    private static Map<Long, JobExecution> executionsById = TransactionAwareProxyFactory.createTransactionalMap();
    private static long currentId = 0L;

    public static void clear() {
        executionsById.clear();
    }

    private static JobExecution copy(JobExecution original) {
        JobExecution copy = (JobExecution)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)original));
        return copy;
    }

    @Override
    public void saveJobExecution(JobExecution jobExecution) {
        Assert.isTrue((jobExecution.getId() == null ? 1 : 0) != 0);
        Long newId = new Long(currentId++);
        jobExecution.setId(newId);
        jobExecution.incrementVersion();
        executionsById.put(newId, MapJobExecutionDao.copy(jobExecution));
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        for (JobExecution exec : executionsById.values()) {
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            executions.add(MapJobExecutionDao.copy(exec));
        }
        Collections.sort(executions, new Comparator<JobExecution>(){

            @Override
            public int compare(JobExecution e1, JobExecution e2) {
                long result = e1.getId() - e2.getId();
                if (result > 0L) {
                    return -1;
                }
                if (result < 0L) {
                    return 1;
                }
                return 0;
            }
        });
        return executions;
    }

    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        Long id = jobExecution.getId();
        Assert.notNull((Object)id, (String)"JobExecution is expected to have an id (should be saved already)");
        Assert.notNull((Object)executionsById.get(id), (String)"JobExecution must already be saved");
        jobExecution.incrementVersion();
        executionsById.put(id, MapJobExecutionDao.copy(jobExecution));
    }

    @Override
    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        JobExecution lastExec = null;
        for (JobExecution exec : executionsById.values()) {
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            if (lastExec == null) {
                lastExec = exec;
            }
            if (!lastExec.getCreateTime().before(exec.getCreateTime())) continue;
            lastExec = exec;
        }
        return MapJobExecutionDao.copy(lastExec);
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        HashSet<JobExecution> result = new HashSet<JobExecution>();
        for (JobExecution exec : executionsById.values()) {
            if (!exec.getJobInstance().getJobName().equals(jobName) || !exec.isRunning()) continue;
            result.add(MapJobExecutionDao.copy(exec));
        }
        return result;
    }

    @Override
    public JobExecution getJobExecution(Long executionId) {
        return MapJobExecutionDao.copy(executionsById.get(executionId));
    }

    @Override
    public void synchronizeStatus(JobExecution jobExecution) {
    }
}

