/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapJobInstanceDao
implements JobInstanceDao {
    private static Collection<JobInstance> jobInstances = TransactionAwareProxyFactory.createTransactionalSet();
    private static long currentId = 0L;

    public static void clear() {
        jobInstances.clear();
    }

    @Override
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        JobInstance jobInstance = new JobInstance(new Long(currentId++), jobParameters, jobName);
        jobInstance.incrementVersion();
        jobInstances.add(jobInstance);
        return jobInstance;
    }

    @Override
    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        for (JobInstance instance : jobInstances) {
            if (!instance.getJobName().equals(jobName) || !instance.getJobParameters().equals(jobParameters)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public JobInstance getJobInstance(Long instanceId) {
        for (JobInstance instance : jobInstances) {
            if (!instance.getId().equals(instanceId)) continue;
            return instance;
        }
        return null;
    }

    @Override
    public List<String> getJobNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (JobInstance instance : jobInstances) {
            result.add(instance.getJobName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<JobInstance> getLastJobInstances(String jobName, int count) {
        ArrayList<JobInstance> list = new ArrayList<JobInstance>(jobInstances);
        Collections.sort(list, new Comparator<JobInstance>(){

            @Override
            public int compare(JobInstance o1, JobInstance o2) {
                return Long.signum(o1.getId() - o2.getId());
            }
        });
        int length = count > list.size() ? list.size() : count;
        return list.subList(0, length);
    }

    @Override
    public JobInstance getJobInstance(JobExecution jobExecution) {
        return jobExecution.getJobInstance();
    }
}

