/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.support;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

public class SimpleJobRepository
implements JobRepository {
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;
    private ExecutionContextDao ecDao;

    SimpleJobRepository() {
    }

    public SimpleJobRepository(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao, ExecutionContextDao ecDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
        this.ecDao = ecDao;
    }

    public boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        return this.jobInstanceDao.getJobInstance(jobName, jobParameters) != null;
    }

    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        ExecutionContext executionContext;
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        if (jobInstance != null) {
            List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(jobInstance);
            for (JobExecution execution : executions) {
                if (execution.isRunning()) {
                    throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + jobInstance);
                }
                if (execution.getStatus() != BatchStatus.COMPLETED) continue;
                throw new JobInstanceAlreadyCompleteException("A job instance already exists and is complete for parameters=" + jobParameters + ".  If you want to run this job again, change the parameters.");
            }
            executionContext = this.ecDao.getExecutionContext(this.jobExecutionDao.getLastJobExecution(jobInstance));
        } else {
            jobInstance = this.jobInstanceDao.createJobInstance(jobName, jobParameters);
            executionContext = new ExecutionContext();
        }
        JobExecution jobExecution = new JobExecution(jobInstance);
        jobExecution.setExecutionContext(executionContext);
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.saveJobExecution(jobExecution);
        return jobExecution;
    }

    public void update(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"JobExecution cannot be null.");
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution must have a Job ID set.");
        Assert.notNull((Object)jobExecution.getId(), (String)"JobExecution must be already saved (have an id assigned).");
        jobExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.jobExecutionDao.updateJobExecution(jobExecution);
    }

    public void add(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.stepExecutionDao.saveStepExecution(stepExecution);
    }

    public void update(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull((Object)stepExecution.getId(), (String)"StepExecution must already be saved (have an id assigned)");
        stepExecution.setLastUpdated(new Date(System.currentTimeMillis()));
        this.stepExecutionDao.updateStepExecution(stepExecution);
        this.checkForInterruption(stepExecution);
    }

    private void validateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"StepExecution cannot be null.");
        Assert.notNull((Object)stepExecution.getStepName(), (String)"StepExecution's step name cannot be null.");
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"StepExecution must belong to persisted JobExecution");
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        this.ecDao.persistExecutionContext(stepExecution.getJobExecution());
        this.ecDao.persistExecutionContext(stepExecution);
    }

    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        List<JobExecution> jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>(jobExecutions.size());
        for (JobExecution jobExecution : jobExecutions) {
            StepExecution stepExecution = this.stepExecutionDao.getStepExecution(jobExecution, stepName);
            if (stepExecution == null) continue;
            stepExecutions.add(stepExecution);
        }
        StepExecution latest = null;
        for (StepExecution stepExecution : stepExecutions) {
            if (latest == null) {
                latest = stepExecution;
            }
            if (latest.getStartTime().getTime() >= stepExecution.getStartTime().getTime()) continue;
            latest = stepExecution;
        }
        if (latest != null) {
            ExecutionContext executionContext = this.ecDao.getExecutionContext(latest);
            latest.setExecutionContext(executionContext);
        }
        return latest;
    }

    public int getStepExecutionCount(JobInstance jobInstance, String stepName) {
        int count = 0;
        List<JobExecution> jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
        for (JobExecution jobExecution : jobExecutions) {
            if (this.stepExecutionDao.getStepExecution(jobExecution, stepName) == null) continue;
            ++count;
        }
        return count;
    }

    private void checkForInterruption(StepExecution stepExecution) {
        JobExecution jobExecution = stepExecution.getJobExecution();
        this.jobExecutionDao.synchronizeStatus(jobExecution);
        if (jobExecution.getStatus() == BatchStatus.STOPPING) {
            stepExecution.setTerminateOnly();
        }
    }

    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobName, jobParameters);
        if (jobInstance == null) {
            return null;
        }
        return this.jobExecutionDao.getLastJobExecution(jobInstance);
    }
}

