/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.resource;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepExecutionPreparedStatementSetter
extends StepExecutionListenerSupport
implements PreparedStatementSetter,
InitializingBean {
    private List<String> parameterKeys;
    private JobParameters jobParameters;

    public void setValues(PreparedStatement ps) throws SQLException {
        Map<String, JobParameter> parameters = this.jobParameters.getParameters();
        for (int i = 0; i < this.parameterKeys.size(); ++i) {
            JobParameter arg = parameters.get(this.parameterKeys.get(i));
            if (arg == null) {
                throw new IllegalStateException("No job parameter found for with key of: [" + this.parameterKeys.get(i) + "]");
            }
            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, (Object)arg.getValue());
        }
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.jobParameters = stepExecution.getJobParameters();
    }

    public void setParameterKeys(List<String> parameterKeys) {
        this.parameterKeys = parameterKeys;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.parameterKeys, (String)"Parameters names must be provided");
    }
}

