/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StepExecutionResourceProxy
extends StepExecutionListenerSupport
implements Resource,
ResourceLoaderAware,
StepExecutionListener {
    private static final String JOB_NAME_PATTERN = "%JOB_NAME%";
    private static final String STEP_NAME_PATTERN = "%STEP_NAME%";
    private static final String DEFAULT_PATTERN = "data/%JOB_NAME%/%STEP_NAME%.txt";
    private String filePattern = "data/%JOB_NAME%/%STEP_NAME%.txt";
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private ResourceLoader resourceLoader = new FileSystemResourceLoader();
    private Resource delegate;

    public Resource createRelative(String relativePath) throws IOException {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.createRelative(relativePath);
    }

    public boolean exists() {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.exists();
    }

    public String getDescription() {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.getDescription();
    }

    public File getFile() throws IOException {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.getFile();
    }

    public String getFilename() {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.getFilename();
    }

    public InputStream getInputStream() throws IOException {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.getInputStream();
    }

    public URI getURI() throws IOException {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.getURI();
    }

    public URL getURL() throws IOException {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.getURL();
    }

    public boolean isOpen() {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.isOpen();
    }

    public boolean isReadable() {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.isReadable();
    }

    public long lastModified() throws IOException {
        Assert.state((this.delegate != null ? 1 : 0) != 0, (String)"The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.lastModified();
    }

    public void setJobParametersFactory(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private String replacePattern(String string, String pattern, String replacement) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(pattern) != -1) {
            return StringUtils.replace((String)string, (String)pattern, (String)replacement);
        }
        return string;
    }

    private String createFileName(String jobName, String stepName, Properties properties) {
        Assert.notNull((Object)this.filePattern, (String)"filename pattern is null");
        String fileName = this.filePattern;
        fileName = this.replacePattern(fileName, JOB_NAME_PATTERN, jobName == null ? "job" : jobName);
        fileName = this.replacePattern(fileName, STEP_NAME_PATTERN, stepName);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                fileName = this.replacePattern(fileName, "%" + key + "%", (String)entry.getValue());
            }
        }
        return fileName;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = this.replacePattern(filePattern, "\\", File.separator);
    }

    public void beforeStep(StepExecution execution) {
        String stepName = execution.getStepName();
        String jobName = execution.getJobExecution().getJobInstance().getJobName();
        Properties properties = this.jobParametersConverter.getProperties(execution.getJobExecution().getJobInstance().getJobParameters());
        this.delegate = this.resourceLoader.getResource(this.createFileName(jobName, stepName, properties));
    }

    public String toString() {
        return this.delegate == null ? this.filePattern : this.delegate.toString();
    }
}

