/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.repeat.context.SynchronizedAttributeAccessor;
import org.springframework.util.Assert;

public class StepContext
extends SynchronizedAttributeAccessor {
    private StepExecution stepExecution;
    private Map<String, Set<Runnable>> callbacks = new HashMap<String, Set<Runnable>>();

    public StepContext(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"A StepContext must have a non-null StepExecution");
        this.stepExecution = stepExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            Set<Runnable> set = this.callbacks.get(name);
            if (set == null) {
                set = new HashSet<Runnable>();
                this.callbacks.put(name, set);
            }
            set.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterDestructionCallbacks(String name) {
        Map<String, Set<Runnable>> map = this.callbacks;
        synchronized (map) {
            this.callbacks.remove(name);
        }
    }

    public Object removeAttribute(String name) {
        this.unregisterDestructionCallbacks(name);
        return super.removeAttribute(name);
    }

    public void close() {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Map<String, Set<Runnable>> copy = Collections.unmodifiableMap(this.callbacks);
        for (String key : copy.keySet()) {
            Set<Runnable> set = copy.get(key);
            for (Runnable callback : set) {
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (RuntimeException t) {
                    errors.add(t);
                }
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        Exception error = (Exception)errors.get(0);
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new UnexpectedJobExecutionException("Could not close step context, rethrowing first of " + errors.size() + " execptions.", error);
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StepContext)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        StepContext context = (StepContext)((Object)other);
        if (context.stepExecution == this.stepExecution) {
            return true;
        }
        return this.stepExecution.equals(context.stepExecution);
    }

    public int hashCode() {
        return this.stepExecution.hashCode();
    }
}

