/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.ChunkContext;
import org.springframework.batch.core.scope.StepContext;
import org.springframework.batch.core.scope.StepSynchronizationManager;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;

public abstract class StepContextRepeatCallback
implements RepeatCallback {
    private final Queue<ChunkContext> attributeQueue = new LinkedBlockingQueue<ChunkContext>();
    private final StepContext stepContext;

    public StepContextRepeatCallback(StepExecution stepExecution) {
        this.stepContext = new StepContext(stepExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExitStatus doInIteration(RepeatContext context) throws Exception {
        ExitStatus exitStatus;
        ChunkContext chunkContext = this.attributeQueue.poll();
        if (chunkContext == null) {
            chunkContext = new ChunkContext();
        }
        int start = this.stepContext.attributeNames().length;
        StepSynchronizationManager.register(this.stepContext);
        try {
            exitStatus = this.doInStepContext(context, this.stepContext);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (chunkContext.attributeNames().length > start) {
                this.attributeQueue.add(chunkContext);
            }
            StepSynchronizationManager.close();
            throw throwable;
        }
        if (chunkContext.attributeNames().length > start) {
            this.attributeQueue.add(chunkContext);
        }
        StepSynchronizationManager.close();
        return exitStatus;
    }

    public abstract ExitStatus doInStepContext(RepeatContext var1, StepContext var2) throws Exception;
}

