/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.batch.core.scope.StepContext;
import org.springframework.batch.core.scope.StepSynchronizationManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public class StepScope
implements Scope,
BeanFactoryPostProcessor,
Ordered {
    private Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Object mutex = new Object();
    public static final String ID_KEY = "STEP_IDENTIFIER";
    private String name = "step";
    private boolean proxyTargetClass;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory objectFactory) {
        StepContext context = this.getContext();
        Object scopedObject = context.getAttribute(name);
        if (scopedObject == null) {
            Object object = this.mutex;
            synchronized (object) {
                scopedObject = context.getAttribute(name);
                if (scopedObject == null) {
                    this.logger.debug((Object)String.format("Creating object in scope=%s, name=%s", this.name, name));
                    scopedObject = objectFactory.getObject();
                    context.setAttribute(name, scopedObject);
                }
            }
        }
        return scopedObject;
    }

    public String getConversationId() {
        StepContext context = this.getContext();
        Object id = context.getAttribute(ID_KEY);
        return "" + id;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        StepContext context = this.getContext();
        this.logger.debug((Object)String.format("Registered destruction callback in scope=%s, name=%s", this.name, name));
        context.registerDestructionCallback(name, callback);
    }

    public Object remove(String name) {
        StepContext context = this.getContext();
        this.logger.debug((Object)String.format("Removing from scope=%s, name=%s", this.name, name));
        return context.removeAttribute(name);
    }

    private StepContext getContext() {
        StepContext context = StepSynchronizationManager.getContext();
        if (context == null) {
            throw new IllegalStateException("No context holder available for step scope");
        }
        return context;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope(this.name, (Scope)this);
        Assert.state((boolean)(beanFactory instanceof BeanDefinitionRegistry), (String)"BeanFactory was not a BeanDefinitionRegistry, so StepScope cannot be used.");
        Scopifier scopifier = new Scopifier((BeanDefinitionRegistry)beanFactory, this.name, this.proxyTargetClass);
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            scopifier.visitBeanDefinition(definition);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    private static class Scopifier
    extends BeanDefinitionVisitor {
        private final boolean proxyTargetClass;
        private final BeanDefinitionRegistry registry;
        private final String scope;

        public Scopifier(BeanDefinitionRegistry registry, String scope, boolean proxyTargetClass) {
            super(new StringValueResolver(){

                public String resolveStringValue(String value) {
                    return value;
                }
            });
            this.registry = registry;
            this.proxyTargetClass = proxyTargetClass;
            this.scope = scope;
        }

        protected Object resolveValue(Object value) {
            BeanDefinitionHolder definition;
            if (value instanceof BeanDefinition) {
                BeanDefinition definition2 = (BeanDefinition)value;
                if (this.scope.equals(definition2.getScope())) {
                    String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition2, (BeanDefinitionRegistry)this.registry);
                    return ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder(definition2, beanName), (BeanDefinitionRegistry)this.registry, (boolean)this.proxyTargetClass);
                }
            } else if (value instanceof BeanDefinitionHolder && this.scope.equals((definition = (BeanDefinitionHolder)value).getBeanDefinition().getScope())) {
                return ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)definition, (BeanDefinitionRegistry)this.registry, (boolean)this.proxyTargetClass);
            }
            return value;
        }
    }
}

