/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope;

import java.util.Stack;
import org.springframework.batch.core.scope.StepContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepSynchronizationManager {
    private static final ThreadLocal<Stack<StepContext>> contextHolder = new ThreadLocal();

    public static StepContext getContext() {
        Stack<StepContext> current = StepSynchronizationManager.getCurrent();
        if (current.isEmpty()) {
            return null;
        }
        return current.peek();
    }

    public static void register(StepContext context) {
        if (context == null) {
            return;
        }
        StepSynchronizationManager.getCurrent().push(context);
    }

    public static void close() {
        StepContext oldSession = StepSynchronizationManager.getContext();
        if (oldSession == null) {
            return;
        }
        StepSynchronizationManager.getCurrent().pop();
    }

    private static Stack<StepContext> getCurrent() {
        if (contextHolder.get() == null) {
            contextHolder.set(new Stack());
        }
        return contextHolder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        StepContext context = StepSynchronizationManager.getContext();
        try {
            if (context != null) {
                context.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            StepSynchronizationManager.close();
            throw throwable;
        }
        StepSynchronizationManager.close();
    }
}

