/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.scope.StepContext;
import org.springframework.batch.core.scope.StepSynchronizationManager;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractStep
implements Step,
InitializingBean,
BeanNameAware {
    public static final String JOB_INTERRUPTED = "JOB_INTERRUPTED";
    private static final Log logger = LogFactory.getLog(AbstractStep.class);
    private String name;
    private int startLimit = Integer.MAX_VALUE;
    private boolean allowStartIfComplete = false;
    private CompositeStepExecutionListener listener = new CompositeStepExecutionListener();
    private JobRepository jobRepository;

    public AbstractStep() {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.jobRepository, (String)"JobRepository is mandatory");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public int getStartLimit() {
        return this.startLimit;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public boolean isAllowStartIfComplete() {
        return this.allowStartIfComplete;
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public AbstractStep(String name) {
        this.name = name;
    }

    protected abstract ExitStatus doExecute(StepExecution var1) throws Exception;

    protected void open(ExecutionContext ctx) throws Exception {
    }

    protected void close(ExecutionContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void execute(StepExecution stepExecution) throws JobInterruptedException, UnexpectedJobExecutionException {
        block34: {
            Exception e3;
            Exception commitException;
            ExitStatus exitStatus;
            block28: {
                stepExecution.setStartTime(new Date());
                stepExecution.setStatus(BatchStatus.STARTED);
                this.getJobRepository().update(stepExecution);
                exitStatus = ExitStatus.FAILED;
                commitException = null;
                StepContext stepContext = new StepContext(stepExecution);
                StepSynchronizationManager.register(stepContext);
                this.getCompositeListener().beforeStep(stepExecution);
                this.open(stepExecution.getExecutionContext());
                exitStatus = this.doExecute(stepExecution);
                if (stepExecution.isTerminateOnly()) {
                    stepExecution.setStatus(BatchStatus.STOPPED);
                    throw new JobInterruptedException("JobExecution interrupted.");
                }
                stepExecution.setStatus(BatchStatus.COMPLETED);
                try {
                    this.getJobRepository().update(stepExecution);
                    this.getJobRepository().updateExecutionContext(stepExecution);
                }
                catch (Exception e2) {
                    commitException = e2;
                    exitStatus = exitStatus.and(ExitStatus.UNKNOWN);
                }
                Object var8_7 = null;
                try {
                    exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
                }
                catch (Exception e3) {
                    logger.error((Object)"Exception in afterStep callback", (Throwable)e3);
                }
                stepExecution.setExitStatus(exitStatus);
                stepExecution.setEndTime(new Date());
                try {
                    this.getJobRepository().update(stepExecution);
                }
                catch (Exception e3) {
                    if (commitException == null) {
                        commitException = e3;
                        break block28;
                    }
                    logger.error((Object)"Exception while updating step execution after commit exception", (Throwable)e3);
                }
            }
            try {
                this.close(stepExecution.getExecutionContext());
            }
            catch (Exception e3) {
                logger.error((Object)"Exception while closing step execution resources", (Throwable)e3);
                stepExecution.addFailureException(e3);
            }
            StepSynchronizationManager.release();
            if (commitException != null) {
                stepExecution.setStatus(BatchStatus.UNKNOWN);
                logger.error((Object)"Encountered an error saving batch meta data.This job is now in an unknown state and should not be restarted.", (Throwable)commitException);
                stepExecution.addFailureException(commitException);
            }
            break block34;
            {
                catch (Throwable e4) {
                    block31: {
                        logger.error((Object)("Encountered an error executing the step: " + e4.getClass() + ": " + e4.getMessage()), e4);
                        stepExecution.setStatus(AbstractStep.determineBatchStatus(e4));
                        exitStatus = this.getDefaultExitStatusForFailure(e4);
                        stepExecution.addFailureException(e4);
                        try {
                            this.getJobRepository().updateExecutionContext(stepExecution);
                        }
                        catch (Exception ex) {
                            logger.error((Object)"Encountered an error on listener error callback.", (Throwable)ex);
                            stepExecution.addFailureException(ex);
                        }
                        Object var8_8 = null;
                        try {
                            exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
                        }
                        catch (Exception e3) {
                            logger.error((Object)"Exception in afterStep callback", (Throwable)e3);
                        }
                        stepExecution.setExitStatus(exitStatus);
                        stepExecution.setEndTime(new Date());
                        try {
                            this.getJobRepository().update(stepExecution);
                        }
                        catch (Exception e3) {
                            if (commitException == null) {
                                commitException = e3;
                                break block31;
                            }
                            logger.error((Object)"Exception while updating step execution after commit exception", (Throwable)e3);
                        }
                    }
                    try {
                        this.close(stepExecution.getExecutionContext());
                    }
                    catch (Exception e3) {
                        logger.error((Object)"Exception while closing step execution resources", (Throwable)e3);
                        stepExecution.addFailureException(e3);
                    }
                    StepSynchronizationManager.release();
                    if (commitException != null) {
                        stepExecution.setStatus(BatchStatus.UNKNOWN);
                        logger.error((Object)"Encountered an error saving batch meta data.This job is now in an unknown state and should not be restarted.", (Throwable)commitException);
                        stepExecution.addFailureException(commitException);
                    }
                }
            }
            catch (Throwable throwable) {
                block33: {
                    Object var8_9 = null;
                    try {
                        exitStatus = exitStatus.and(this.getCompositeListener().afterStep(stepExecution));
                    }
                    catch (Exception e3) {
                        logger.error((Object)"Exception in afterStep callback", (Throwable)e3);
                    }
                    stepExecution.setExitStatus(exitStatus);
                    stepExecution.setEndTime(new Date());
                    try {
                        this.getJobRepository().update(stepExecution);
                    }
                    catch (Exception e3) {
                        if (commitException == null) {
                            commitException = e3;
                            break block33;
                        }
                        logger.error((Object)"Exception while updating step execution after commit exception", (Throwable)e3);
                    }
                }
                try {
                    this.close(stepExecution.getExecutionContext());
                }
                catch (Exception e3) {
                    logger.error((Object)"Exception while closing step execution resources", (Throwable)e3);
                    stepExecution.addFailureException(e3);
                }
                StepSynchronizationManager.release();
                if (commitException != null) {
                    stepExecution.setStatus(BatchStatus.UNKNOWN);
                    logger.error((Object)"Encountered an error saving batch meta data.This job is now in an unknown state and should not be restarted.", (Throwable)commitException);
                    stepExecution.addFailureException(commitException);
                }
                throw throwable;
            }
        }
    }

    private static BatchStatus determineBatchStatus(Throwable e) {
        if (e instanceof FatalException) {
            return BatchStatus.UNKNOWN;
        }
        if (e instanceof JobInterruptedException || e.getCause() instanceof JobInterruptedException) {
            return BatchStatus.STOPPED;
        }
        return BatchStatus.FAILED;
    }

    public void registerStepExecutionListener(StepExecutionListener listener) {
        this.listener.register(listener);
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    protected StepExecutionListener getCompositeListener() {
        return this.listener;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    protected JobRepository getJobRepository() {
        return this.jobRepository;
    }

    private ExitStatus getDefaultExitStatusForFailure(Throwable ex) {
        ExitStatus exitStatus;
        if (ex instanceof JobInterruptedException || ex.getCause() instanceof JobInterruptedException) {
            exitStatus = new ExitStatus(false, JOB_INTERRUPTED, JobInterruptedException.class.getName());
        } else if (ex instanceof NoSuchJobException || ex.getCause() instanceof NoSuchJobException) {
            exitStatus = new ExitStatus(false, "NO_SUCH_JOB", ex.getClass().getName());
        } else {
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            String message = writer.toString();
            exitStatus = ExitStatus.FAILED.addExitDescription(message);
        }
        return exitStatus;
    }

    protected static class FatalException
    extends RuntimeException {
        public FatalException(String string, Throwable e) {
            super(string, e);
        }
    }
}

