/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.AbstractItemOrientedTasklet;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.RetryState;
import org.springframework.batch.retry.support.DefaultRetryState;
import org.springframework.batch.support.Classifier;
import org.springframework.core.AttributeAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaultTolerantChunkOrientedTasklet<I, O>
extends AbstractItemOrientedTasklet<I, O> {
    private final RetryOperations retryOperations;
    private final ItemSkipPolicy writeSkipPolicy;
    private final ItemSkipPolicy processSkipPolicy;
    private final Classifier<Throwable, Boolean> rollbackClassifier;

    public AbstractFaultTolerantChunkOrientedTasklet(ItemReader<? extends I> itemReader, ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, RetryOperations retryOperations, ItemSkipPolicy processSkipPolicy, ItemSkipPolicy writeSkipPolicy, Classifier<Throwable, Boolean> rollbackClassifier) {
        super(itemReader, itemProcessor, itemWriter);
        this.retryOperations = retryOperations;
        this.processSkipPolicy = processSkipPolicy;
        this.writeSkipPolicy = writeSkipPolicy;
        this.rollbackClassifier = rollbackClassifier;
    }

    protected void callSkipListeners(List<Exception> skippedReads, Map<I, Exception> skippedInputs, Map<O, Exception> skippedOutputs) {
        for (Exception exception : skippedReads) {
            try {
                this.listener.onSkipInRead(exception);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, exception);
            }
        }
        for (Map.Entry entry : skippedInputs.entrySet()) {
            try {
                this.listener.onSkipInProcess(entry.getKey(), (Throwable)entry.getValue());
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, (Throwable)entry.getValue());
            }
        }
        for (Map.Entry entry : skippedOutputs.entrySet()) {
            try {
                this.listener.onSkipInWrite(entry.getKey(), (Throwable)entry.getValue());
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in skip listener", ex, (Throwable)entry.getValue());
            }
        }
    }

    protected static <T> List<T> getBufferedList(AttributeAccessor attributes, String key) {
        List buffer;
        if (!attributes.hasAttribute(key)) {
            buffer = new ArrayList();
            attributes.setAttribute(key, buffer);
        } else {
            List casted = (List)attributes.getAttribute(key);
            buffer = casted;
        }
        return buffer;
    }

    protected static <T> Map<T, Exception> getBufferedSkips(AttributeAccessor attributes, String key) {
        Map buffer;
        if (!attributes.hasAttribute(key)) {
            buffer = new LinkedHashMap();
            attributes.setAttribute(key, buffer);
        } else {
            Map casted = (Map)attributes.getAttribute(key);
            buffer = casted;
        }
        return buffer;
    }

    protected void process(final StepContribution contribution, List<I> inputs, List<O> outputs, final Map<I, Exception> skippedInputs) throws Exception {
        int filtered = 0;
        for (final I item : inputs) {
            RecoveryCallback recoveryCallback;
            RetryCallback retryCallback = new RetryCallback<O>(){

                public O doWithRetry(RetryContext context) throws Exception {
                    Object output = AbstractFaultTolerantChunkOrientedTasklet.this.doProcess(item);
                    return output;
                }
            };
            Object output = this.retryOperations.execute(retryCallback, recoveryCallback = new RecoveryCallback<O>(){

                public O recover(RetryContext context) throws Exception {
                    Exception e = context.getLastThrowable();
                    if (AbstractFaultTolerantChunkOrientedTasklet.this.processSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                        contribution.incrementProcessSkipCount();
                        skippedInputs.put(item, e);
                        AbstractFaultTolerantChunkOrientedTasklet.this.logger.debug((Object)"Skipping after failed process", (Throwable)e);
                        return null;
                    }
                    throw new RetryException("Non-skippable exception in recoverer while processing", (Throwable)e);
                }
            }, (RetryState)new DefaultRetryState(item, this.rollbackClassifier));
            if (output != null) {
                outputs.add(output);
                continue;
            }
            ++filtered;
        }
        contribution.incrementFilterCount(filtered);
    }

    protected void write(final List<O> chunk, final StepContribution contribution, final Map<O, Exception> skipped) throws Exception {
        RetryCallback<Object> retryCallback = new RetryCallback<Object>(){

            public Object doWithRetry(RetryContext context) throws Exception {
                AbstractFaultTolerantChunkOrientedTasklet.this.doWrite(chunk);
                contribution.incrementWriteCount(chunk.size());
                return null;
            }
        };
        RecoveryCallback<Object> recoveryCallback = new RecoveryCallback<Object>(){

            public Object recover(RetryContext context) throws Exception {
                if (chunk.size() == 1) {
                    Exception e = context.getLastThrowable();
                    Object item = chunk.get(0);
                    this.checkSkipPolicy(item, e, contribution);
                    return null;
                }
                Exception le = context.getLastThrowable();
                if (!((Boolean)AbstractFaultTolerantChunkOrientedTasklet.this.rollbackClassifier.classify((Object)le)).booleanValue()) {
                    throw new RetryException("Invalid retry state during write caused by exception that does not classify for rollback: ", (Throwable)le);
                }
                for (Object item : chunk) {
                    try {
                        AbstractFaultTolerantChunkOrientedTasklet.this.doWrite(Collections.singletonList(item));
                        contribution.incrementWriteCount(1);
                    }
                    catch (Exception e) {
                        this.checkSkipPolicy(item, e, contribution);
                        if (((Boolean)AbstractFaultTolerantChunkOrientedTasklet.this.rollbackClassifier.classify((Object)e)).booleanValue()) {
                            throw e;
                        }
                        throw new RetryException("Invalid retry state during recovery caused by exception that does not classify for rollback: ", (Throwable)e);
                    }
                }
                return null;
            }

            private void checkSkipPolicy(O item, Exception e, StepContribution contribution2) {
                if (!AbstractFaultTolerantChunkOrientedTasklet.this.writeSkipPolicy.shouldSkip(e, contribution2.getStepSkipCount())) {
                    throw new RetryException("Non-skippable exception in recoverer", (Throwable)e);
                }
                contribution2.incrementWriteSkipCount();
                skipped.put(item, e);
                AbstractFaultTolerantChunkOrientedTasklet.this.logger.debug((Object)"Skipping after failed write", (Throwable)e);
            }
        };
        this.retryOperations.execute((RetryCallback)retryCallback, (RecoveryCallback)recoveryCallback, (RetryState)new DefaultRetryState(skipped, this.rollbackClassifier));
    }
}

