/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemOrientedTasklet<I, O>
implements Tasklet {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ItemReader<? extends I> itemReader;
    protected final ItemProcessor<? super I, ? extends O> itemProcessor;
    protected final ItemWriter<? super O> itemWriter;
    protected final MulticasterBatchListener<I, O> listener = new MulticasterBatchListener();

    public AbstractItemOrientedTasklet(ItemReader<? extends I> itemReader, ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter) {
        this.itemReader = itemReader;
        this.itemProcessor = itemProcessor;
        this.itemWriter = itemWriter;
    }

    public void setListeners(StepListener[] listeners) {
        for (StepListener listener : listeners) {
            this.registerListener(listener);
        }
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected final I doRead() throws Exception {
        try {
            this.listener.beforeRead();
            Object item = this.itemReader.read();
            this.listener.afterRead(item);
            return (I)item;
        }
        catch (Exception e) {
            this.listener.onReadError(e);
            throw e;
        }
    }

    protected final O doProcess(I item) throws Exception {
        try {
            this.listener.beforeProcess(item);
            Object result = this.itemProcessor.process(item);
            this.listener.afterProcess(item, result);
            return (O)result;
        }
        catch (Exception e) {
            this.listener.onProcessError(item, e);
            throw e;
        }
    }

    protected final void doWrite(List<O> items) throws Exception {
        try {
            this.listener.beforeWrite(items);
            this.itemWriter.write(items);
            this.listener.afterWrite(items);
        }
        catch (Exception e) {
            this.listener.onWriteError(e, items);
            throw e;
        }
    }
}

