/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.CompositeChunkListener;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.listener.RepeatListenerSupport;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.util.Assert;

abstract class BatchListenerFactoryHelper {
    BatchListenerFactoryHelper() {
    }

    public static RepeatOperations addChunkListeners(RepeatOperations chunkOperations, StepListener[] listeners) {
        final CompositeChunkListener multicaster = new CompositeChunkListener();
        boolean hasChunkListener = false;
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (listener instanceof ChunkListener) {
                hasChunkListener = true;
            }
            if (!(listener instanceof ChunkListener)) continue;
            multicaster.register((ChunkListener)listener);
        }
        if (hasChunkListener) {
            Assert.state((boolean)(chunkOperations instanceof RepeatTemplate), (String)"Chunk operations is injected but not a RepeatTemplate, so chunk listeners cannot also be registered. Either inject a RepeatTemplate, or remove the ChunkListener.");
            RepeatTemplate stepTemplate = (RepeatTemplate)chunkOperations;
            stepTemplate.registerListener((RepeatListener)new RepeatListenerSupport(){

                public void open(RepeatContext context) {
                    multicaster.beforeChunk();
                }

                public void close(RepeatContext context) {
                    multicaster.afterChunk();
                }
            });
        }
        return chunkOperations;
    }

    public static StepExecutionListener[] getStepListeners(StepListener[] listeners) {
        ArrayList<StepExecutionListener> list = new ArrayList<StepExecutionListener>();
        for (int i = 0; i < listeners.length; ++i) {
            StepListener listener = listeners[i];
            if (!(listener instanceof StepExecutionListener)) continue;
            list.add((StepExecutionListener)listener);
        }
        return list.toArray(new StepExecutionListener[list.size()]);
    }
}

