/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.step.item.ItemWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Chunk<W>
implements Iterable<W> {
    private List<W> items = new ArrayList<W>();
    private List<ItemWrapper<W>> skips = new ArrayList<ItemWrapper<W>>();

    Chunk() {
    }

    public void add(W item) {
        this.items.add(item);
    }

    public void clear() {
        this.items.clear();
    }

    public List<W> getItems() {
        return Collections.unmodifiableList(new ArrayList<W>(this.items));
    }

    public List<ItemWrapper<W>> getSkips() {
        return Collections.unmodifiableList(new ArrayList<ItemWrapper<W>>(this.skips));
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public ChunkIterator iterator() {
        return new ChunkIterator(this.items);
    }

    public int size() {
        return this.items.size();
    }

    public String toString() {
        return String.format("[items=%s, skips=%s]", this.items, this.skips);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChunkIterator
    implements Iterator<W> {
        private final Iterator<W> iterator;
        private W next;

        public ChunkIterator(List<W> items) {
            this.iterator = items.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public W next() {
            this.next = this.iterator.next();
            return this.next;
        }

        public void remove(Exception e) {
            if (this.next == null) {
                if (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                } else {
                    return;
                }
            }
            Chunk.this.skips.add(new ItemWrapper(this.next, e));
            this.iterator.remove();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("To remove an item you must provide an exception.");
        }
    }
}

