/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.AbstractFaultTolerantChunkOrientedTasklet;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.support.Classifier;
import org.springframework.core.AttributeAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantChunkOrientedTasklet<I, S>
extends AbstractFaultTolerantChunkOrientedTasklet<I, S> {
    private static final String INPUT_BUFFER_KEY = "INPUT_BUFFER_KEY";
    private final RepeatOperations repeatOperations;
    private final ItemSkipPolicy readSkipPolicy;
    private static final String SKIPPED_OUTPUTS_KEY = "SKIPPED_OUTPUTS_BUFFER_KEY";
    private static final String SKIPPED_INPUTS_KEY = "SKIPPED_INPUTS_BUFFER_KEY";
    private static final String SKIPPED_READS_KEY = "SKIPPED_READS_BUFFER_KEY";

    public FaultTolerantChunkOrientedTasklet(ItemReader<? extends I> itemReader, ItemProcessor<? super I, ? extends S> itemProcessor, ItemWriter<? super S> itemWriter, RepeatOperations chunkOperations, RetryOperations retryTemplate, Classifier<Throwable, Boolean> rollbackClassifier, ItemSkipPolicy readSkipPolicy, ItemSkipPolicy writeSkipPolicy, ItemSkipPolicy processSkipPolicy) {
        super(itemReader, itemProcessor, itemWriter, retryTemplate, processSkipPolicy, writeSkipPolicy, rollbackClassifier);
        this.repeatOperations = chunkOperations;
        this.readSkipPolicy = readSkipPolicy;
    }

    @Override
    public ExitStatus execute(final StepContribution contribution, AttributeAccessor attributes) throws Exception {
        final List inputs = FaultTolerantChunkOrientedTasklet.getBufferedList(attributes, INPUT_BUFFER_KEY);
        ArrayList outputs = new ArrayList();
        ExitStatus result = ExitStatus.CONTINUABLE;
        final List<Exception> skippedReads = FaultTolerantChunkOrientedTasklet.getBufferedList(attributes, SKIPPED_READS_KEY);
        if (inputs.isEmpty() && outputs.isEmpty()) {
            result = this.repeatOperations.iterate(new RepeatCallback(){

                public ExitStatus doInIteration(RepeatContext context) throws Exception {
                    Object item = FaultTolerantChunkOrientedTasklet.this.read(contribution, skippedReads);
                    if (item == null) {
                        return ExitStatus.FINISHED;
                    }
                    inputs.add(item);
                    contribution.incrementReadCount();
                    return ExitStatus.CONTINUABLE;
                }
            });
            if (inputs.isEmpty()) {
                return result;
            }
        }
        Map skippedInputs = FaultTolerantChunkOrientedTasklet.getBufferedSkips(attributes, SKIPPED_INPUTS_KEY);
        if (!inputs.isEmpty()) {
            inputs.removeAll(skippedInputs.keySet());
            this.process(contribution, inputs, outputs, skippedInputs);
        }
        Map skippedOutputs = FaultTolerantChunkOrientedTasklet.getBufferedSkips(attributes, SKIPPED_OUTPUTS_KEY);
        outputs.removeAll(skippedOutputs.keySet());
        this.write(outputs, contribution, skippedOutputs);
        this.callSkipListeners(skippedReads, skippedInputs, skippedOutputs);
        for (String key : attributes.attributeNames()) {
            attributes.removeAttribute(key);
        }
        inputs.clear();
        skippedInputs.clear();
        skippedOutputs.clear();
        return result;
    }

    protected I read(StepContribution contribution, List<Exception> skippedReads) throws Exception {
        while (true) {
            try {
                return this.doRead();
            }
            catch (Exception e) {
                if (this.readSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                    contribution.incrementReadSkipCount();
                    skippedReads.add(e);
                    this.logger.debug((Object)"Skipping failed input", (Throwable)e);
                    continue;
                }
                throw new NonSkippableReadException("Non-skippable exception during read", e);
            }
            break;
        }
    }
}

