/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.springframework.batch.core.step.item.FaultTolerantChunkOrientedTasklet;
import org.springframework.batch.core.step.item.NonbufferingFaultTolerantChunkOrientedTasklet;
import org.springframework.batch.core.step.item.SimpleRetryExceptionHandler;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.policy.ExceptionClassifierRetryPolicy;
import org.springframework.batch.retry.policy.MapRetryContextCache;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.batch.retry.support.RetryTemplate;
import org.springframework.batch.support.Classifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultTolerantStepFactoryBean<T, S>
extends SimpleStepFactoryBean<T, S> {
    private int skipLimit = 0;
    private Collection<Class<? extends Throwable>> skippableExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private Collection<Class<? extends Throwable>> fatalExceptionClasses = new HashSet<Class<? extends Throwable>>();
    private int cacheCapacity;
    private int retryLimit;
    private Collection<Class<? extends Throwable>> retryableExceptionClasses;
    private BackOffPolicy backOffPolicy;
    private RetryListener[] retryListeners;
    private RetryPolicy retryPolicy;
    private RetryContextCache retryContextCache;
    private boolean isReaderTransactionalQueue;

    public FaultTolerantStepFactoryBean() {
        this.fatalExceptionClasses.add(Error.class);
        this.skippableExceptionClasses.add(Exception.class);
        this.cacheCapacity = 0;
        this.retryLimit = 0;
        this.retryableExceptionClasses = new HashSet<Class<? extends Throwable>>();
        this.isReaderTransactionalQueue = false;
    }

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.isReaderTransactionalQueue = isReaderTransactionalQueue;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setRetryableExceptionClasses(Collection<Class<? extends Throwable>> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
    }

    public void setRetryListeners(RetryListener[] retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkippableExceptionClasses(Collection<Class<? extends Throwable>> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setFatalExceptionClasses(Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }

    @Override
    protected void applyConfiguration(TaskletStep step) {
        super.applyConfiguration(step);
        if (this.retryLimit > 0 || this.skipLimit > 0 || this.retryPolicy != null) {
            this.addFatalExceptionIfMissing(SkipLimitExceededException.class);
            this.addFatalExceptionIfMissing(NonSkippableReadException.class);
            this.addFatalExceptionIfMissing(SkipListenerFailedException.class);
            this.addFatalExceptionIfMissing(RetryException.class);
            if (this.retryPolicy == null) {
                SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy(this.retryLimit);
                if (!this.retryableExceptionClasses.isEmpty()) {
                    simpleRetryPolicy.setRetryableExceptionClasses(this.retryableExceptionClasses);
                }
                simpleRetryPolicy.setFatalExceptionClasses(this.fatalExceptionClasses);
                ExceptionClassifierRetryPolicy classifierRetryPolicy = new ExceptionClassifierRetryPolicy();
                HashMap<Class<? extends Throwable>, SimpleRetryPolicy> exceptionTypeMap = new HashMap<Class<? extends Throwable>, SimpleRetryPolicy>();
                for (Class<? extends Throwable> cls : this.retryableExceptionClasses) {
                    exceptionTypeMap.put(cls, simpleRetryPolicy);
                }
                classifierRetryPolicy.setPolicyMap(exceptionTypeMap);
                this.retryPolicy = classifierRetryPolicy;
            }
            RetryTemplate retryTemplate = new RetryTemplate();
            if (this.backOffPolicy != null) {
                retryTemplate.setBackOffPolicy(this.backOffPolicy);
            }
            retryTemplate.setRetryPolicy(this.retryPolicy);
            Classifier<Throwable, Boolean> rollbackClassifier = new Classifier<Throwable, Boolean>(){

                public Boolean classify(Throwable classifiable) {
                    return FaultTolerantStepFactoryBean.this.getTransactionAttribute().rollbackOn(classifiable);
                }
            };
            RepeatOperations stepOperations = this.getStepOperations();
            if (stepOperations instanceof RepeatTemplate) {
                ((RepeatTemplate)stepOperations).setExceptionHandler((ExceptionHandler)new SimpleRetryExceptionHandler(this.retryPolicy, this.getExceptionHandler(), this.fatalExceptionClasses));
            }
            if (this.retryContextCache == null) {
                if (this.cacheCapacity > 0) {
                    retryTemplate.setRetryContextCache((RetryContextCache)new MapRetryContextCache(this.cacheCapacity));
                }
            } else {
                retryTemplate.setRetryContextCache(this.retryContextCache);
            }
            if (this.retryListeners != null) {
                retryTemplate.setListeners(this.retryListeners);
            }
            ArrayList<Class<? extends Throwable>> exceptions = new ArrayList<Class<? extends Throwable>>(this.skippableExceptionClasses);
            LimitCheckingItemSkipPolicy readSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, this.skippableExceptionClasses, new ArrayList<Class<? extends Throwable>>(this.fatalExceptionClasses));
            exceptions.addAll(new ArrayList<Class<? extends Throwable>>(this.retryableExceptionClasses));
            LimitCheckingItemSkipPolicy writeSkipPolicy = new LimitCheckingItemSkipPolicy(this.skipLimit, exceptions, new ArrayList<Class<? extends Throwable>>(this.fatalExceptionClasses));
            if (this.isReaderTransactionalQueue) {
                NonbufferingFaultTolerantChunkOrientedTasklet tasklet = new NonbufferingFaultTolerantChunkOrientedTasklet(this.getItemReader(), this.getItemProcessor(), this.getItemWriter(), this.getChunkOperations(), (RetryOperations)retryTemplate, rollbackClassifier, readSkipPolicy, writeSkipPolicy, writeSkipPolicy);
                tasklet.setListeners(this.getListeners());
                step.setTasklet(tasklet);
            } else {
                FaultTolerantChunkOrientedTasklet tasklet = new FaultTolerantChunkOrientedTasklet(this.getItemReader(), this.getItemProcessor(), this.getItemWriter(), this.getChunkOperations(), (RetryOperations)retryTemplate, rollbackClassifier, readSkipPolicy, writeSkipPolicy, writeSkipPolicy);
                tasklet.setListeners(this.getListeners());
                step.setTasklet(tasklet);
            }
        }
    }

    public void addFatalExceptionIfMissing(Class<? extends Throwable> cls) {
        ArrayList<Class<? extends Throwable>> fatalExceptionList = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> exceptionClass : this.fatalExceptionClasses) {
            fatalExceptionList.add(exceptionClass);
        }
        if (!fatalExceptionList.contains(cls)) {
            fatalExceptionList.add(cls);
        }
        this.fatalExceptionClasses = fatalExceptionList;
    }
}

