/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.AbstractFaultTolerantChunkOrientedTasklet;
import org.springframework.batch.core.step.skip.ItemSkipPolicy;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.support.Classifier;
import org.springframework.core.AttributeAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonbufferingFaultTolerantChunkOrientedTasklet<I, O>
extends AbstractFaultTolerantChunkOrientedTasklet<I, O> {
    private static final String SKIPPED_INPUTS_KEY = "SKIPPED_INPUTS_KEY";
    private static final String SKIPPED_OUTPUTS_KEY = "SKIPPED_OUTPUTS_KEY";
    private static final String SKIPPED_READS_KEY = "SKIPPED_READS_KEY";
    private final RepeatOperations repeatOperations;
    private final ItemSkipPolicy readSkipPolicy;

    public NonbufferingFaultTolerantChunkOrientedTasklet(ItemReader<? extends I> itemReader, ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, RepeatOperations chunkOperations, RetryOperations retryTemplate, Classifier<Throwable, Boolean> rollbackClassifier, ItemSkipPolicy readSkipPolicy, ItemSkipPolicy writeSkipPolicy, ItemSkipPolicy processSkipPolicy) {
        super(itemReader, itemProcessor, itemWriter, retryTemplate, processSkipPolicy, writeSkipPolicy, rollbackClassifier);
        this.repeatOperations = chunkOperations;
        this.readSkipPolicy = readSkipPolicy;
    }

    @Override
    public ExitStatus execute(final StepContribution contribution, AttributeAccessor attributes) throws Exception {
        ExitStatus result = ExitStatus.CONTINUABLE;
        final ArrayList inputs = new ArrayList();
        final List<Exception> skippedReads = NonbufferingFaultTolerantChunkOrientedTasklet.getBufferedList(attributes, SKIPPED_READS_KEY);
        result = this.repeatOperations.iterate(new RepeatCallback(){

            public ExitStatus doInIteration(RepeatContext context) throws Exception {
                Object item = NonbufferingFaultTolerantChunkOrientedTasklet.this.read(contribution, skippedReads);
                if (item == null) {
                    return ExitStatus.FINISHED;
                }
                inputs.add(item);
                contribution.incrementReadCount();
                return ExitStatus.CONTINUABLE;
            }
        });
        Map skippedInputs = NonbufferingFaultTolerantChunkOrientedTasklet.getBufferedSkips(attributes, SKIPPED_INPUTS_KEY);
        inputs.removeAll(skippedInputs.keySet());
        if (inputs.isEmpty()) {
            return result;
        }
        ArrayList outputs = new ArrayList();
        this.process(contribution, inputs, outputs, skippedInputs);
        Map skippedOutputs = NonbufferingFaultTolerantChunkOrientedTasklet.getBufferedSkips(attributes, SKIPPED_OUTPUTS_KEY);
        outputs.removeAll(skippedOutputs.keySet());
        this.write(outputs, contribution, skippedOutputs);
        this.callSkipListeners(skippedReads, skippedInputs, skippedOutputs);
        return result;
    }

    private I read(StepContribution contribution, List<Exception> skipped) throws Exception {
        try {
            return this.doRead();
        }
        catch (Exception e) {
            if (this.readSkipPolicy.shouldSkip(e, contribution.getStepSkipCount())) {
                contribution.incrementReadSkipCount();
                skipped.add(e);
                this.logger.debug((Object)"Skipping failed input", (Throwable)e);
            }
            throw e;
        }
    }
}

