/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.AbstractItemOrientedTasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.core.AttributeAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleChunkOrientedTasklet<I, O>
extends AbstractItemOrientedTasklet<I, O> {
    private RepeatOperations repeatOperations;

    public SimpleChunkOrientedTasklet(ItemReader<? extends I> itemReader, ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter, RepeatOperations repeatOperations) {
        super(itemReader, itemProcessor, itemWriter);
        this.repeatOperations = repeatOperations;
    }

    @Override
    public ExitStatus execute(final StepContribution contribution, AttributeAccessor attributes) throws Exception {
        ExitStatus result = ExitStatus.CONTINUABLE;
        final ArrayList inputs = new ArrayList();
        result = this.repeatOperations.iterate(new RepeatCallback(){

            public ExitStatus doInIteration(RepeatContext context) throws Exception {
                Object item = SimpleChunkOrientedTasklet.this.doRead();
                if (item == null) {
                    return ExitStatus.FINISHED;
                }
                inputs.add(item);
                contribution.incrementReadCount();
                return ExitStatus.CONTINUABLE;
            }
        });
        if (inputs.isEmpty()) {
            return result;
        }
        ArrayList outputs = new ArrayList();
        for (Object item : inputs) {
            Object output = this.doProcess(item);
            if (output == null) continue;
            outputs.add(output);
        }
        contribution.incrementFilterCount(inputs.size() - outputs.size());
        this.doWrite(outputs);
        contribution.incrementWriteCount(outputs.size());
        return result;
    }
}

