/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.tasklet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.StepContext;
import org.springframework.batch.core.scope.StepContextRepeatCallback;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.StepExecutionSynchronizer;
import org.springframework.batch.core.step.StepExecutionSynchronizerFactory;
import org.springframework.batch.core.step.StepInterruptionPolicy;
import org.springframework.batch.core.step.ThreadStepInterruptionPolicy;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.support.CompositeItemStream;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.core.AttributeAccessor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class TaskletStep
extends AbstractStep {
    private static final Log logger = LogFactory.getLog(TaskletStep.class);
    private RepeatOperations stepOperations = new RepeatTemplate();
    private StepInterruptionPolicy interruptionPolicy = new ThreadStepInterruptionPolicy();
    private CompositeItemStream stream = new CompositeItemStream();
    private PlatformTransactionManager transactionManager;
    private TransactionAttribute transactionAttribute = new DefaultTransactionAttribute(){

        public boolean rollbackOn(Throwable ex) {
            return true;
        }
    };
    private Tasklet tasklet;
    private StepExecutionSynchronizer synchronizer = new StepExecutionSynchronizerFactory().getStepExecutionSynchronizer();

    public TaskletStep() {
        this(null);
    }

    public TaskletStep(String name) {
        super(name);
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
        if (tasklet instanceof StepExecutionListener) {
            this.registerStepExecutionListener((StepExecutionListener)((Object)tasklet));
        }
    }

    public void setStepExecutionListeners(StepExecutionListener[] listeners) {
        for (int i = 0; i < listeners.length; ++i) {
            this.registerStepExecutionListener(listeners[i]);
        }
    }

    public void setStreams(ItemStream[] streams) {
        for (int i = 0; i < streams.length; ++i) {
            this.registerStream(streams[i]);
        }
    }

    public void registerStream(ItemStream stream) {
        this.stream.register(stream);
    }

    public void setStepOperations(RepeatOperations stepOperations) {
        this.stepOperations = stepOperations;
    }

    public void setInterruptionPolicy(StepInterruptionPolicy interruptionPolicy) {
        this.interruptionPolicy = interruptionPolicy;
    }

    public void setSynchronizer(StepExecutionSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    protected ExitStatus doExecute(StepExecution stepExecution) throws Exception {
        this.stream.update(stepExecution.getExecutionContext());
        this.getJobRepository().updateExecutionContext(stepExecution);
        return this.stepOperations.iterate((RepeatCallback)new StepContextRepeatCallback(stepExecution){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ExitStatus doInStepContext(RepeatContext repeatContext, StepContext stepContext) throws Exception {
                StepExecution stepExecution = stepContext.getStepExecution();
                ExceptionHolder fatalException = new ExceptionHolder();
                StepContribution contribution = stepExecution.createStepContribution();
                stepExecution.getExecutionContext().clearDirtyFlag();
                TaskletStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                ExitStatus exitStatus = ExitStatus.CONTINUABLE;
                TransactionStatus transaction = TaskletStep.this.transactionManager.getTransaction((TransactionDefinition)TaskletStep.this.transactionAttribute);
                boolean locked = false;
                try {
                    try {
                        exitStatus = TaskletStep.this.tasklet.execute(contribution, (AttributeAccessor)stepContext);
                    }
                    finally {
                        logger.debug((Object)("Applying contribution: " + contribution));
                        stepExecution.apply(contribution);
                    }
                    stepExecution.incrementCommitCount();
                    try {
                        TaskletStep.this.synchronizer.lock(stepExecution);
                        locked = true;
                    }
                    catch (InterruptedException e) {
                        stepExecution.setStatus(BatchStatus.STOPPED);
                        Thread.currentThread().interrupt();
                    }
                    if (stepExecution.getExecutionContext().isDirty()) {
                        throw new IllegalStateException("The ExecutionContext cannot be modified outside of the ItemStream#Update method");
                    }
                    TaskletStep.this.stream.update(stepExecution.getExecutionContext());
                    try {
                        TaskletStep.this.getJobRepository().updateExecutionContext(stepExecution);
                    }
                    catch (Exception e) {
                        fatalException.setException(e);
                        stepExecution.setStatus(BatchStatus.UNKNOWN);
                        throw new AbstractStep.FatalException("Fatal error detected during save of step execution context", e);
                    }
                    try {
                        TaskletStep.this.transactionManager.commit(transaction);
                    }
                    catch (Exception e) {
                        fatalException.setException(e);
                        stepExecution.setStatus(BatchStatus.UNKNOWN);
                        logger.error((Object)"Fatal error detected during commit.");
                        throw new AbstractStep.FatalException("Fatal error detected during commit", e);
                    }
                    try {
                        logger.debug((Object)("Saving step execution after commit: " + stepExecution));
                        TaskletStep.this.getJobRepository().update(stepExecution);
                    }
                    catch (Exception e) {
                        fatalException.setException(e);
                        stepExecution.setStatus(BatchStatus.UNKNOWN);
                        throw new AbstractStep.FatalException("Fatal error detected during update of step execution", e);
                    }
                }
                catch (Error e) {
                    TaskletStep.this.processRollback(stepExecution, fatalException, transaction);
                    throw e;
                }
                catch (Exception e) {
                    TaskletStep.this.processRollback(stepExecution, fatalException, transaction);
                    throw e;
                }
                finally {
                    if (locked) {
                        TaskletStep.this.synchronizer.release(stepExecution);
                    }
                    locked = false;
                }
                TaskletStep.this.interruptionPolicy.checkInterrupted(stepExecution);
                return exitStatus;
            }
        });
    }

    private void processRollback(StepExecution stepExecution, ExceptionHolder fatalException, TransactionStatus transaction) {
        block3: {
            stepExecution.rollback();
            try {
                this.transactionManager.rollback(transaction);
            }
            catch (Exception e) {
                if (fatalException.hasException()) break block3;
                fatalException.setException(e);
                throw new AbstractStep.FatalException("Failed while processing rollback", e);
            }
        }
        if (fatalException.hasException()) {
            this.getJobRepository().update(stepExecution);
        }
    }

    protected void close(ExecutionContext ctx) throws Exception {
        this.stream.close(ctx);
    }

    protected void open(ExecutionContext ctx) throws Exception {
        this.stream.open(ctx);
    }

    private static class ExceptionHolder {
        private Exception exception;

        private ExceptionHolder() {
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

