/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class JobParameters
implements Serializable {
    private final Map stringMap;
    private final Map longMap;
    private final Map doubleMap;
    private final Map dateMap;

    public JobParameters() {
        this.stringMap = new LinkedHashMap();
        this.longMap = new LinkedHashMap();
        this.doubleMap = new LinkedHashMap();
        this.dateMap = new LinkedHashMap();
    }

    public JobParameters(Map stringMap, Map longMap, Map doubleMap, Map dateMap) {
        this.validateMap(stringMap, String.class);
        this.validateMap(longMap, Long.class);
        this.validateMap(doubleMap, Double.class);
        this.validateMap(dateMap, Date.class);
        this.stringMap = new LinkedHashMap(stringMap);
        this.longMap = new LinkedHashMap(longMap);
        this.doubleMap = new LinkedHashMap(doubleMap);
        this.dateMap = this.copyDateMap(dateMap);
    }

    public String getString(String key) {
        return (String)this.stringMap.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.longMap.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.doubleMap.get(key);
    }

    public Date getDate(String key) {
        return (Date)this.dateMap.get(key);
    }

    public Map getParameters() {
        LinkedHashMap tempMap = new LinkedHashMap(this.stringMap);
        tempMap.putAll(this.longMap);
        tempMap.putAll(this.doubleMap);
        tempMap.putAll(this.dateMap);
        return Collections.unmodifiableMap(tempMap);
    }

    public Map getStringParameters() {
        return Collections.unmodifiableMap(this.stringMap);
    }

    public Map getLongParameters() {
        return Collections.unmodifiableMap(this.longMap);
    }

    public Map getDoubleParameters() {
        return Collections.unmodifiableMap(this.doubleMap);
    }

    public Map getDateParameters() {
        return Collections.unmodifiableMap(this.dateMap);
    }

    public boolean isEmpty() {
        return this.dateMap.isEmpty() && this.longMap.isEmpty() && this.doubleMap.isEmpty() && this.stringMap.isEmpty();
    }

    private void validateMap(Map map, Class type) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("All parameter keys must be strings.");
            }
            if (entry.getValue().getClass() == type) continue;
            throw new IllegalArgumentException("The values in this map must be of type:[" + type + "].");
        }
    }

    private Map copyDateMap(Map dateMap) {
        LinkedHashMap tempMap = new LinkedHashMap();
        Iterator it = dateMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Date date = (Date)entry.getValue();
            tempMap.put(entry.getKey(), new Date(date.getTime()));
        }
        return tempMap;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameters)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        JobParameters parameters = (JobParameters)obj;
        return ((Object)this.getParameters()).equals(parameters.getParameters());
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 21).append((Object)this.stringMap).append((Object)this.longMap).append((Object)this.doubleMap).append((Object)this.dateMap).toHashCode();
    }

    public String toString() {
        return this.stringMap.toString() + this.longMap.toString() + this.doubleMap.toString() + this.dateMap.toString();
    }
}

